/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyException;
import io.gravitee.policy.api.PolicyChain;

public abstract class AbstractPolicy
implements Policy {
    @Override
    public void onRequest(Object ... args) throws PolicyException {
        ExecutionContext executionContext = this.getParameterAssignableTo(ExecutionContext.class, args);
        PolicyChain policyChain = this.getParameterAssignableTo(PolicyChain.class, args);
        Request request = this.getParameterAssignableTo(Request.class, args);
        Response response = this.getParameterAssignableTo(Response.class, args);
        this.onRequest(request, response, policyChain, executionContext);
    }

    protected void onRequest(Request request, Response response, PolicyChain policyChain, ExecutionContext executionContext) throws PolicyException {
    }

    @Override
    public void onResponse(Object ... args) throws PolicyException {
        ExecutionContext executionContext = this.getParameterAssignableTo(ExecutionContext.class, args);
        PolicyChain policyChain = this.getParameterAssignableTo(PolicyChain.class, args);
        Request request = this.getParameterAssignableTo(Request.class, args);
        Response response = this.getParameterAssignableTo(Response.class, args);
        this.onResponse(request, response, policyChain, executionContext);
    }

    protected void onResponse(Request request, Response response, PolicyChain policyChain, ExecutionContext executionContext) throws PolicyException {
    }

    protected <T> T getParameterAssignableTo(Class<T> paramType, Object ... args) {
        for (Object arg : args) {
            if (!paramType.isAssignableFrom(arg.getClass())) continue;
            return (T)arg;
        }
        return null;
    }
}

