/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.PolicyFactory;
import io.gravitee.gateway.policy.PolicyManager;
import io.gravitee.gateway.policy.PolicyMetadata;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.gateway.policy.impl.DelegatingClassLoader;
import io.gravitee.gateway.policy.impl.PolicyImpl;
import io.gravitee.gateway.policy.impl.PolicyMetadataBuilder;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.handler.ReactorHandler;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.plugin.policy.internal.PolicyMethodResolver;
import io.gravitee.policy.api.PolicyConfiguration;
import io.gravitee.resource.api.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class DefaultPolicyManager
extends AbstractLifecycleComponent<PolicyManager>
implements PolicyManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultPolicyManager.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PolicyFactory policyFactory;
    @Autowired
    private PolicyConfigurationFactory policyConfigurationFactory;
    private final Map<String, PolicyMetadata> policies = new HashMap<String, PolicyMetadata>();

    protected void doStart() throws Exception {
        this.initialize();
    }

    protected void doStop() throws Exception {
        this.policies.values().forEach(policy -> {
            ClassLoader policyClassLoader = policy.classloader();
            if (policyClassLoader instanceof PluginClassLoader) {
                try {
                    ((PluginClassLoader)policyClassLoader).close();
                }
                catch (IOException e) {
                    this.logger.error("Unable to close policy classloader for policy {}", (Object)policy.id());
                }
            }
        });
        this.policies.clear();
    }

    private void initialize() {
        String[] beanNamesForType = this.applicationContext.getParent().getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{PolicyPlugin.class}));
        ConfigurablePluginManager ppm = (ConfigurablePluginManager)this.applicationContext.getParent().getBean(beanNamesForType[0]);
        PolicyClassLoaderFactory pclf = (PolicyClassLoaderFactory)this.applicationContext.getBean(PolicyClassLoaderFactory.class);
        ReactorHandler rh = (ReactorHandler)this.applicationContext.getBean(ReactorHandler.class);
        ResourceLifecycleManager rm = (ResourceLifecycleManager)this.applicationContext.getBean(ResourceLifecycleManager.class);
        Reactable reactable = (Reactable)this.applicationContext.getBean(Reactable.class);
        Set requiredPlugins = reactable.dependencies(io.gravitee.definition.model.Policy.class);
        requiredPlugins.forEach(policy -> {
            block12: {
                PluginClassLoader policyClassLoader;
                PolicyPlugin policyPlugin = (PolicyPlugin)ppm.get(policy.getName());
                if (policyPlugin == null) {
                    this.logger.error("Policy [{}] can not be found in policy registry", (Object)policy.getName());
                    throw new IllegalStateException("Policy [" + policy.getName() + "] can not be found in policy registry");
                }
                Collection resources = rm.getResources();
                if (!resources.isEmpty()) {
                    ClassLoader[] resourceClassLoaders = (ClassLoader[])rm.getResources().stream().map(new Function<Resource, ClassLoader>(){

                        @Override
                        public ClassLoader apply(Resource resource) {
                            return resource.getClass().getClassLoader();
                        }
                    }).toArray(ClassLoader[]::new);
                    DelegatingClassLoader parentClassLoader = new DelegatingClassLoader(rh.getClass().getClassLoader(), resourceClassLoaders);
                    policyClassLoader = pclf.getOrCreateClassLoader((Plugin)policyPlugin, (ClassLoader)parentClassLoader);
                } else {
                    policyClassLoader = pclf.getOrCreateClassLoader((Plugin)policyPlugin, rh.getClass().getClassLoader());
                }
                this.logger.debug("Loading policy {} for {}", (Object)policy.getName(), (Object)rh);
                PolicyMetadataBuilder builder = new PolicyMetadataBuilder();
                builder.setId(policyPlugin.id());
                try {
                    Class policyClass = ClassUtils.forName((String)policyPlugin.policy().getName(), (ClassLoader)policyClassLoader);
                    builder.setPolicy(policyClass).setClassLoader((ClassLoader)policyClassLoader).setMethods(new PolicyMethodResolver().resolve(policyClass));
                    if (policyPlugin.configuration() != null) {
                        builder.setConfiguration(ClassUtils.forName((String)policyPlugin.configuration().getName(), (ClassLoader)policyClassLoader));
                    }
                    this.policies.put(policy.getName(), builder.build());
                }
                catch (Exception ex) {
                    this.logger.error("Unable to load policy metadata", (Throwable)ex);
                    if (policyClassLoader != null) {
                        try {
                            policyClassLoader.close();
                        }
                        catch (IOException ioe) {
                            this.logger.error("Unable to close classloader for policy", (Throwable)ioe);
                        }
                    }
                }
                catch (Error error) {
                    this.logger.error("Unable to load policy id[" + policyPlugin.id() + "]. This error mainly occurs when the policy is linked to a missing resource, for example a cache or an oauth2 resource. Please check your policy configuration!", (Throwable)error);
                    if (policyClassLoader == null) break block12;
                    try {
                        policyClassLoader.close();
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unable to close classloader for policy", (Throwable)ioe);
                    }
                }
            }
        });
    }

    @Override
    public Policy create(StreamType streamType, String policy, String configuration) {
        PolicyMetadata metadata = this.policies.get(policy);
        if (metadata != null && metadata.accept(streamType)) {
            PolicyConfiguration policyConfiguration = this.policyConfigurationFactory.create(metadata.configuration(), configuration);
            Object policyInst = this.policyFactory.create(metadata, policyConfiguration);
            this.logger.debug("Policy {} has been added to the policy chain", (Object)metadata.id());
            return PolicyImpl.target(policyInst).definition(metadata).build();
        }
        return null;
    }
}

