/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

class DelegatingClassLoader
extends ClassLoader {
    private final ClassLoader[] delegates;
    private final ClassLoader mParentLoader;

    DelegatingClassLoader(ClassLoader parent, ClassLoader ... classLoaderDelegates) {
        super(parent);
        this.delegates = classLoaderDelegates;
        ClassLoader systemCL = DelegatingClassLoader.getSystemClassLoader();
        this.mParentLoader = parent != null ? parent : systemCL;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> class2Load = this.findLoadedClass(name);
        if (class2Load != null) {
            if (resolve) {
                this.resolveClass(class2Load);
            }
            return class2Load;
        }
        try {
            class2Load = this.findClass(name);
            if (class2Load != null) {
                if (resolve) {
                    this.resolveClass(class2Load);
                }
                return class2Load;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            class2Load = this.mParentLoader.loadClass(name);
            if (resolve) {
                this.resolveClass(class2Load);
            }
            return class2Load;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException(name);
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        boolean found = false;
        Class<?> sharedClass = null;
        for (ClassLoader classloader : this.delegates) {
            try {
                sharedClass = classloader.loadClass(name);
                found = true;
                break;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        if (!found) {
            throw new ClassNotFoundException(name);
        }
        return sharedClass;
    }

    public String toString() {
        return "DelegatingClassLoader(" + this.getParent() + "," + this.delegates + "," + System.identityHashCode(this) + ")";
    }
}

