/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import com.google.common.base.Throwables;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.core.processor.ProcessorFailure;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyChainException;
import io.gravitee.gateway.policy.impl.processor.PolicyChainProcessorFailure;
import io.gravitee.policy.api.PolicyResult;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PolicyChain
extends BufferedReadWriteStream
implements io.gravitee.policy.api.PolicyChain,
StreamableProcessor<ExecutionContext, Buffer> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static final String GATEWAY_POLICY_INTERNAL_ERROR_KEY = "GATEWAY_POLICY_INTERNAL_ERROR";
    protected Handler<ExecutionContext> resultHandler;
    protected Handler<ProcessorFailure> errorHandler;
    private Handler<ProcessorFailure> streamErrorHandler;
    protected final List<Policy> policies;
    private final Iterator<Policy> policyIterator;
    protected final ExecutionContext executionContext;

    protected PolicyChain(List<Policy> policies, ExecutionContext executionContext) {
        Objects.requireNonNull(policies, "Policies must not be null");
        Objects.requireNonNull(executionContext, "ExecutionContext must not be null");
        this.policies = policies;
        this.executionContext = executionContext;
        this.policyIterator = this.iterator();
    }

    public void doNext(Request request, Response response) {
        block5: {
            if (this.policyIterator.hasNext()) {
                Policy policy = this.policyIterator.next();
                try {
                    if (policy.isRunnable()) {
                        this.execute(policy, new Object[]{this, this.executionContext.request(), this.executionContext.response(), this.executionContext});
                        break block5;
                    }
                    this.doNext(this.executionContext.request(), this.executionContext.response());
                }
                catch (Exception ex) {
                    request.metrics().setMessage("An error occurs in policy[" + policy.id() + "] error[" + Throwables.getStackTraceAsString((Throwable)ex) + "]");
                    if (this.errorHandler != null) {
                        this.errorHandler.handle((Object)new PolicyChainProcessorFailure(PolicyResult.failure((String)GATEWAY_POLICY_INTERNAL_ERROR_KEY, (String)ex.getMessage())));
                    }
                    break block5;
                }
            }
            this.resultHandler.handle((Object)this.executionContext);
        }
    }

    public void failWith(PolicyResult policyResult) {
        this.errorHandler.handle((Object)new PolicyChainProcessorFailure(policyResult));
    }

    public void streamFailWith(PolicyResult policyResult) {
        this.streamErrorHandler.handle((Object)new PolicyChainProcessorFailure(policyResult));
    }

    public void handle(ExecutionContext context) {
        this.doNext(context.request(), context.response());
    }

    public StreamableProcessor<ExecutionContext, Buffer> handler(Handler<ExecutionContext> handler) {
        this.resultHandler = handler;
        return this;
    }

    public StreamableProcessor<ExecutionContext, Buffer> errorHandler(Handler<ProcessorFailure> handler) {
        this.errorHandler = handler;
        return this;
    }

    public StreamableProcessor<ExecutionContext, Buffer> streamErrorHandler(Handler<ProcessorFailure> handler) {
        this.streamErrorHandler = handler;
        return this;
    }

    public StreamableProcessor<ExecutionContext, Buffer> exitHandler(Handler<Void> handler) {
        return this;
    }

    protected abstract void execute(Policy var1, Object ... var2) throws PolicyChainException;

    protected abstract Iterator<Policy> iterator();
}

