/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.policy.api.PolicyConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyConfigurationFactoryImpl
implements PolicyConfigurationFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(PolicyConfigurationFactoryImpl.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    public <T extends PolicyConfiguration> T create(Class<T> policyConfigurationClass, String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            this.LOGGER.debug("Unable to create a Policy configuration from a null or empty configuration data");
            return null;
        }
        try {
            return (T)((PolicyConfiguration)this.mapper.readValue(configuration, policyConfigurationClass));
        }
        catch (IOException ex) {
            this.LOGGER.error("Unable to instance Policy configuration for {}", (Object)policyConfigurationClass.getName(), (Object)ex);
            return null;
        }
    }
}

