/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import com.google.common.base.Predicate;
import io.gravitee.gateway.policy.PolicyFactory;
import io.gravitee.gateway.policy.PolicyMetadata;
import io.gravitee.policy.api.PolicyConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFactoryImpl
implements PolicyFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(PolicyFactoryImpl.class);
    private Map<Class<?>, Constructor<?>> constructors = new HashMap();

    @Override
    public Object create(PolicyMetadata policyMetadata, PolicyConfiguration policyConfiguration) {
        Class<?> policyClass = policyMetadata.policy();
        this.LOGGER.debug("Create a new policy instance for {}", (Object)policyClass.getName());
        return this.createPolicy(policyMetadata, policyConfiguration);
    }

    private Object createPolicy(PolicyMetadata policyMetadata, PolicyConfiguration policyConfiguration) {
        Object policyInst = null;
        Constructor<?> constr = this.lookingForConstructor(policyMetadata.policy());
        if (constr != null) {
            try {
                policyInst = constr.getParameterCount() > 0 ? constr.newInstance(policyConfiguration) : constr.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                this.LOGGER.error("Unable to instantiate policy {}", (Object)policyMetadata.policy().getName(), (Object)ex);
            }
        }
        return policyInst;
    }

    private Constructor<?> lookingForConstructor(Class<?> policyClass) {
        Constructor<?> constructor = this.constructors.get(policyClass);
        if (constructor == null) {
            this.LOGGER.debug("Looking for a constructor to inject policy configuration");
            Set policyConstructors = ReflectionUtils.getConstructors(policyClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), PolicyFactoryImpl.withParametersAssignableFrom(PolicyConfiguration.class), ReflectionUtils.withParametersCount((int)1)});
            if (policyConstructors.isEmpty()) {
                this.LOGGER.debug("No configuration can be injected for {} because there is no valid constructor. Using default empty constructor.", (Object)policyClass.getName());
                try {
                    constructor = policyClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    this.LOGGER.error("Unable to find default empty constructor for {}", (Object)policyClass.getName(), (Object)nsme);
                }
            } else if (policyConstructors.size() == 1) {
                constructor = (Constructor<?>)policyConstructors.iterator().next();
            } else {
                this.LOGGER.info("Too much constructors to instantiate policy {}", (Object)policyClass.getName());
            }
            this.constructors.put(policyClass, constructor);
        }
        return constructor;
    }

    private static Predicate<Member> withParametersAssignableFrom(Class ... types) {
        return input -> {
            Class[] parameterTypes;
            if (input != null && (parameterTypes = PolicyFactoryImpl.parameterTypes(input)).length == types.length) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (types[i].isAssignableFrom(parameterTypes[i]) && (parameterTypes[i] != Object.class || types[i] == Object.class)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }
}

