/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.policy.AbstractPolicy;
import io.gravitee.gateway.policy.PolicyException;
import io.gravitee.gateway.policy.PolicyMetadata;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import java.lang.reflect.Method;

public class PolicyImpl
extends AbstractPolicy {
    private final Object policyInst;
    private PolicyMetadata policyMetadata;

    private PolicyImpl(Object policyInst) {
        this.policyInst = policyInst;
    }

    @Override
    public String id() {
        return this.policyMetadata.id();
    }

    @Override
    public void onRequest(Object ... args) throws PolicyException {
        this.invoke(this.policyMetadata.method(OnRequest.class), args);
    }

    @Override
    public void onResponse(Object ... args) throws PolicyException {
        this.invoke(this.policyMetadata.method(OnResponse.class), args);
    }

    @Override
    public ReadWriteStream<Buffer> onResponseContent(Object ... args) throws PolicyException {
        Object stream = this.invoke(this.policyMetadata.method(OnResponseContent.class), args);
        return stream != null ? (ReadWriteStream)stream : null;
    }

    @Override
    public boolean isStreamable() {
        return this.policyMetadata.method(OnRequestContent.class) != null || this.policyMetadata.method(OnResponseContent.class) != null;
    }

    @Override
    public boolean isRunnable() {
        return this.policyMetadata.method(OnRequest.class) != null || this.policyMetadata.method(OnResponse.class) != null;
    }

    @Override
    public ReadWriteStream<Buffer> onRequestContent(Object ... args) throws PolicyException {
        Object stream = this.invoke(this.policyMetadata.method(OnRequestContent.class), args);
        return stream != null ? (ReadWriteStream)stream : null;
    }

    private Object invoke(Method invokedMethod, Object ... args) throws PolicyException {
        if (invokedMethod != null) {
            Class<?>[] parametersType = invokedMethod.getParameterTypes();
            Object[] parameters = new Object[parametersType.length];
            int idx = 0;
            for (Class<?> paramType : parametersType) {
                parameters[idx++] = this.getParameterAssignableTo(paramType, args);
            }
            try {
                return invokedMethod.invoke(this.policyInst, parameters);
            }
            catch (Exception ex) {
                throw new PolicyException(ex);
            }
        }
        return null;
    }

    public static Builder target(Object policyInstance) {
        return new Builder(policyInstance);
    }

    private PolicyImpl definition(PolicyMetadata policyMetadata) {
        this.policyMetadata = policyMetadata;
        return this;
    }

    public static class Builder {
        private final Object policyInstance;
        private PolicyMetadata policyMetadata;

        private Builder(Object policyInstance) {
            this.policyInstance = policyInstance;
        }

        public Builder definition(PolicyMetadata policyMetadata) {
            this.policyMetadata = policyMetadata;
            return this;
        }

        public PolicyImpl build() {
            return new PolicyImpl(this.policyInstance).definition(this.policyMetadata);
        }
    }
}

