/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import io.gravitee.gateway.policy.PolicyMetadata;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.policy.api.PolicyConfiguration;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class PolicyMetadataBuilder {
    private String id;
    private Class<? extends PolicyConfiguration> configuration;
    private Class<?> policy;
    private Map<Class<? extends Annotation>, Method> methods;
    private ClassLoader classLoader;

    public PolicyMetadataBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public PolicyMetadataBuilder setConfiguration(Class<? extends PolicyConfiguration> configuration) {
        this.configuration = configuration;
        return this;
    }

    public PolicyMetadataBuilder setPolicy(Class<?> policy) {
        this.policy = policy;
        return this;
    }

    public PolicyMetadataBuilder setMethods(Map<Class<? extends Annotation>, Method> methods) {
        this.methods = methods;
        return this;
    }

    public PolicyMetadataBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public PolicyMetadata build() {
        return new PolicyMetadata(){

            @Override
            public String id() {
                return PolicyMetadataBuilder.this.id;
            }

            @Override
            public Class<?> policy() {
                return PolicyMetadataBuilder.this.policy;
            }

            @Override
            public Class<? extends PolicyConfiguration> configuration() {
                return PolicyMetadataBuilder.this.configuration;
            }

            @Override
            public ClassLoader classloader() {
                return PolicyMetadataBuilder.this.classLoader;
            }

            @Override
            public Method method(Class<? extends Annotation> type) {
                return (Method)PolicyMetadataBuilder.this.methods.get(type);
            }

            @Override
            public boolean accept(StreamType stream) {
                return stream == StreamType.ON_REQUEST && (this.method(OnRequest.class) != null || this.method(OnRequestContent.class) != null) || stream == StreamType.ON_RESPONSE && (this.method(OnResponse.class) != null || this.method(OnResponseContent.class) != null);
            }
        };
    }
}

