/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.policy.impl;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.core.processor.ProcessorFailure;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.impl.PolicyChain;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamablePolicyChain
extends PolicyChain {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ReadWriteStream<Buffer> streamablePolicyHandlerChain;
    private boolean initialized;
    private boolean streamErrorHandle = false;

    protected StreamablePolicyChain(List<Policy> policies, ExecutionContext executionContext) {
        super(policies, executionContext);
    }

    @Override
    public void doNext(Request request, Response response) {
        if (!this.initialized && !this.policies.isEmpty()) {
            this.prepareStreamablePolicyChain(request, response);
            this.initialized = true;
        }
        super.doNext(request, response);
    }

    private void prepareStreamablePolicyChain(Request request, Response response) {
        ReadWriteStream<Buffer> previousPolicyStreamer = null;
        for (Policy policy : this.policies) {
            if (!policy.isStreamable()) continue;
            try {
                ReadWriteStream<Buffer> streamer = this.stream(policy, new Object[]{request, response, this, this.executionContext});
                if (streamer == null) continue;
                if (this.streamablePolicyHandlerChain == null) {
                    this.streamablePolicyHandlerChain = streamer;
                }
                if (previousPolicyStreamer != null) {
                    previousPolicyStreamer.bodyHandler(arg_0 -> streamer.write(arg_0));
                    previousPolicyStreamer.endHandler(result1 -> streamer.end());
                }
                previousPolicyStreamer = streamer;
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while running onXXXXContent for policy {}", (Object)policy, (Object)ex);
            }
        }
        ReadWriteStream<Buffer> tailPolicyStreamer = previousPolicyStreamer;
        if (this.streamablePolicyHandlerChain != null && tailPolicyStreamer != null) {
            tailPolicyStreamer.bodyHandler(bodyPart -> {
                if (this.bodyHandler != null) {
                    this.bodyHandler.handle(bodyPart);
                }
            });
            tailPolicyStreamer.endHandler(result -> {
                if (this.endHandler != null) {
                    this.endHandler.handle(result);
                }
            });
        }
    }

    @Override
    public StreamableProcessor<ExecutionContext, Buffer> streamErrorHandler(Handler<ProcessorFailure> handler) {
        super.streamErrorHandler((Handler<ProcessorFailure>)((Handler)processorFailure -> {
            this.streamErrorHandle = true;
            handler.handle(processorFailure);
        }));
        return this;
    }

    public StreamablePolicyChain write(Buffer chunk) {
        if (this.streamablePolicyHandlerChain != null) {
            this.streamablePolicyHandlerChain.write((Object)chunk);
        } else {
            this.bodyHandler.handle((Object)chunk);
        }
        return this;
    }

    public void end() {
        if (!this.streamErrorHandle) {
            if (this.streamablePolicyHandlerChain != null) {
                this.streamablePolicyHandlerChain.end();
            } else if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    protected abstract ReadWriteStream<Buffer> stream(Policy var1, Object ... var2) throws Exception;
}

