/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.fhir.FhirJsonDataFormat;
import org.apache.camel.component.fhir.springboot.FhirJsonDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, FhirJsonDataFormatConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.dataformat", "camel.dataformat.fhir-json"})
public class FhirJsonDataFormatAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private FhirJsonDataFormatConfiguration configuration;

    public FhirJsonDataFormatAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public DataFormatCustomizer configureFhirJsonDataFormatFactory() {
        return new DataFormatCustomizer(){

            public void configure(String name, DataFormat target) {
                CamelPropertiesHelper.copyProperties((CamelContext)FhirJsonDataFormatAutoConfiguration.this.camelContext, (Object)((Object)FhirJsonDataFormatAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, DataFormat target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)FhirJsonDataFormatAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.fhir-json.customizer"}) && target instanceof FhirJsonDataFormat;
            }
        };
    }
}

