/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.gwt;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.gwt.GWTToSeamAdapter;
import org.jboss.seam.remoting.gwt.SeamRPCRequest;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractResource;

public abstract class GWTService
extends AbstractResource
implements SerializationPolicyProvider {
    protected static final LogProvider log = Logging.getLogProvider(GWTService.class);
    private static final HashMap<String, Class<?>> TYPE_NAMES = new HashMap();
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();
    private final ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    private final ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();

    public String getResourcePath() {
        return "/gwt";
    }

    protected abstract ServerSerializationStreamReader getStreamReader();

    protected abstract ServerSerializationStreamWriter getStreamWriter();

    protected abstract String createResponse(ServerSerializationStreamWriter var1, Class var2, Object var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            this.perThreadRequest.set(request);
            this.perThreadResponse.set(response);
            new ContextualHttpServletRequest(request){

                public void process() throws Exception {
                    try {
                        String requestPayload = GWTService.this.RemoteServiceServlet_readContent(request);
                        GWTService.this.RemoteServiceServlet_onBeforeRequestDeserialized(requestPayload);
                        String responsePayload = GWTService.this.processCall(requestPayload);
                        GWTService.this.RemoteServiceServlet_onAfterResponseSerialized(responsePayload);
                        GWTService.this.RemoteServiceServlet_writeResponse(request, response, responsePayload);
                    }
                    catch (Throwable e) {
                        GWTService.this.RemoteServiceServlet_doUnexpectedFailure(e);
                    }
                }

                protected void restoreConversationId() {
                    ConversationPropagation.instance().setConversationId(((HttpServletRequest)GWTService.this.perThreadRequest.get()).getParameter("conversationId"));
                }

                protected void handleConversationPropagation() {
                }
            }.run();
        }
        finally {
            this.perThreadRequest.remove();
            this.perThreadResponse.remove();
        }
    }

    public String processCall(String payload) throws SerializationException {
        try {
            SeamRPCRequest rpcRequest = GWTService.RPC_decodeRequest(payload, ((Object)((Object)this)).getClass(), this);
            return GWTService.RPC_invokeAndEncodeResponse((Object)this, rpcRequest.getMethod(), rpcRequest.getParameterTypes(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.getServletContext().log("An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected final HttpServletRequest getThreadLocalRequest() {
        return this.perThreadRequest.get();
    }

    protected final HttpServletResponse getThreadLocalResponse() {
        return this.perThreadResponse.get();
    }

    public static SeamRPCRequest RPC_decodeRequest(String encodedRequest, Class<?> type, SerializationPolicyProvider serializationPolicyProvider) {
        if (encodedRequest == null) {
            throw new NullPointerException("encodedRequest cannot be null");
        }
        if (encodedRequest.length() == 0) {
            throw new IllegalArgumentException("encodedRequest cannot be empty");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> serviceIntf;
            ServerSerializationStreamReader streamReader = new ServerSerializationStreamReader(classLoader, serializationPolicyProvider);
            streamReader.prepareToRead(encodedRequest);
            String serviceIntfName = streamReader.readString();
            SerializationPolicy serializationPolicy = streamReader.getSerializationPolicy();
            try {
                serviceIntf = GWTService.RPC_getClassFromSerializedName(serviceIntfName, classLoader);
                if (!RemoteService.class.isAssignableFrom(serviceIntf)) {
                    throw new IncompatibleRemoteServiceException("Blocked attempt to access interface '" + GWTService.printTypeName(serviceIntf) + "', which doesn't extend RemoteService; this is either misconfiguration or a hack attempt");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IncompatibleRemoteServiceException("Could not locate requested interface '" + serviceIntfName + "' in default classloader", (Throwable)e);
            }
            String serviceMethodName = streamReader.readString();
            int paramCount = streamReader.readInt();
            Class[] parameterTypes = new Class[paramCount];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String paramClassName = streamReader.readString();
                try {
                    parameterTypes[i] = GWTService.RPC_getClassFromSerializedName(paramClassName, classLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IncompatibleRemoteServiceException("Parameter " + i + " of is of an unknown type '" + paramClassName + "'", (Throwable)e);
                }
            }
            try {
                Method method = serviceIntf.getMethod(serviceMethodName, parameterTypes);
                Object[] parameterValues = new Object[parameterTypes.length];
                for (int i = 0; i < parameterValues.length; ++i) {
                    parameterValues[i] = streamReader.deserializeValue(parameterTypes[i]);
                }
                return new SeamRPCRequest(method, parameterValues, parameterTypes, serializationPolicy);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleRemoteServiceException(GWTService.formatMethodNotFoundErrorMessage(serviceIntf, serviceMethodName, parameterTypes));
            }
        }
        catch (SerializationException ex) {
            throw new IncompatibleRemoteServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static Class<?> RPC_getClassFromSerializedName(String serializedName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> value = TYPE_NAMES.get(serializedName);
        if (value != null) {
            return value;
        }
        return Class.forName(serializedName, false, classLoader);
    }

    public static String RPC_invokeAndEncodeResponse(Object target, Method serviceMethod, Class[] paramTypes, Object[] args, SerializationPolicy serializationPolicy) throws SerializationException {
        String responsePayload;
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        try {
            GWTToSeamAdapter adapter = GWTToSeamAdapter.instance();
            String serviceIntfName = serviceMethod.getDeclaringClass().getName();
            GWTToSeamAdapter.ReturnedObject returnedObject = adapter.callWebRemoteMethod(serviceIntfName, serviceMethod.getName(), paramTypes, args);
            responsePayload = RPC.encodeResponseForSuccess((Method)serviceMethod, (Object)returnedObject.returnedObject, (SerializationPolicy)serializationPolicy);
        }
        catch (IllegalAccessException e) {
            SecurityException securityException = new SecurityException(GWTService.formatIllegalAccessErrorMessage(target, serviceMethod));
            securityException.initCause(e);
            throw securityException;
        }
        catch (IllegalArgumentException e) {
            SecurityException securityException = new SecurityException(GWTService.formatIllegalArgumentErrorMessage(target, serviceMethod, args));
            securityException.initCause(e);
            throw securityException;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            responsePayload = RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)cause, (SerializationPolicy)serializationPolicy);
        }
        return responsePayload;
    }

    protected void RemoteServiceServlet_onAfterResponseSerialized(String serializedResponse) {
    }

    protected void RemoteServiceServlet_onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected String RemoteServiceServlet_readContent(HttpServletRequest request) throws ServletException, IOException {
        return RPCServletUtils.readContentAsUtf8((HttpServletRequest)request, (boolean)true);
    }

    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            this.getServletContext().log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.");
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.getServletContext().log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.getServletContext().log(message);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(contextRelativePath + strongName));
            InputStream is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
                    }
                    catch (ParseException e) {
                        this.getServletContext().log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getServletContext().log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.getServletContext().log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return serializationPolicy;
    }

    private void RemoteServiceServlet_writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        boolean gzipEncode = RPCServletUtils.acceptsGzipEncoding((HttpServletRequest)request) && this.shouldCompressResponse(request, response, responsePayload);
        RPCServletUtils.writeResponse((ServletContext)this.getServletContext(), (HttpServletResponse)response, (String)responsePayload, (boolean)gzipEncode);
    }

    protected void RemoteServiceServlet_doUnexpectedFailure(Throwable e) {
        ServletContext servletContext = this.getServletContext();
        RPCServletUtils.writeResponseForUnexpectedFailure((ServletContext)servletContext, (HttpServletResponse)this.getThreadLocalResponse(), (Throwable)e);
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RPCServletUtils.exceedsUncompressedContentLengthLimit((String)responsePayload);
    }

    private static String formatMethodNotFoundErrorMessage(Class<?> serviceIntf, String serviceMethodName, Class<?>[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append("Could not locate requested method '");
        sb.append(serviceMethodName);
        sb.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(GWTService.printTypeName(parameterTypes[i]));
        }
        sb.append(")'");
        sb.append(" in interface '");
        sb.append(GWTService.printTypeName(serviceIntf));
        sb.append("'");
        return sb.toString();
    }

    private static String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(GWTService.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(GWTService.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private static String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(GWTService.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(GWTService.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private static String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    private static String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return GWTService.printTypeName(componentType) + "[]";
        }
        return type.getName().replace('$', '.');
    }

    static {
        TYPE_NAMES.put("Z", Boolean.TYPE);
        TYPE_NAMES.put("B", Byte.TYPE);
        TYPE_NAMES.put("C", Character.TYPE);
        TYPE_NAMES.put("D", Double.TYPE);
        TYPE_NAMES.put("F", Float.TYPE);
        TYPE_NAMES.put("I", Integer.TYPE);
        TYPE_NAMES.put("J", Long.TYPE);
        TYPE_NAMES.put("S", Short.TYPE);
    }
}

