/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.AsyncEventNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.CompensationEventListener;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.integration.impl.SimpleValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowProcessInstanceImpl
extends ProcessInstanceImpl
implements WorkflowProcessInstance,
NodeInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowProcessInstanceImpl.class);
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private AtomicLong singleNodeInstanceCounter = new AtomicLong(-1L);
    private Map<String, List<EventListener>> eventListeners = new HashMap<String, List<EventListener>>();
    private Map<String, List<EventListener>> externalEventListeners = new HashMap<String, List<EventListener>>();
    private List<String> completedNodeIds = new ArrayList<String>();
    private List<String> activatingNodeIds;
    private Map<String, Integer> iterationLevels = new HashMap<String, Integer>();
    private int currentLevel;
    private boolean persisted = false;
    private Object faultData;
    private boolean signalCompletion = true;
    private String deploymentId;
    private String correlationKey;
    private Date startDate;
    private int slaCompliance = 0;
    private Date slaDueDate;
    private long slaTimerId = -1L;
    private AgendaFilter agendaFilter;

    @Override
    public NodeContainer getNodeContainer() {
        return this.getWorkflowProcess();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        if (nodeInstance.getId() == -1L) {
            long id = this.singleNodeInstanceCounter.incrementAndGet();
            ((NodeInstanceImpl)nodeInstance).setId(id);
        }
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public int getLevelForNode(String uniqueID) {
        if ("true".equalsIgnoreCase(System.getProperty("jbpm.loop.level.disabled"))) {
            return 1;
        }
        Integer value = this.iterationLevels.get(uniqueID);
        if (value == null && this.currentLevel == 0) {
            value = 1;
        } else if (value == null && this.currentLevel > 0 || value != null && this.currentLevel > 0 && value > this.currentLevel) {
            value = this.currentLevel;
        } else {
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
        }
        this.iterationLevels.put(uniqueID, value);
        return value;
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        if (((NodeInstanceImpl)nodeInstance).isInversionOfControl()) {
            this.getKnowledgeRuntime().delete(this.getKnowledgeRuntime().getFactHandle((Object)nodeInstance));
        }
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection<org.kie.api.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.kie.api.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof org.kie.api.runtime.process.NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public NodeInstance getNodeInstance(long nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getId() != nodeInstanceId) continue;
            return nodeInstance;
        }
        return null;
    }

    public NodeInstance getNodeInstanceByNodeId(long nodeId, boolean recursive) {
        for (NodeInstance nodeInstance : this.getNodeInstances(recursive)) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(long nodeInstanceId, boolean recursive) {
        for (NodeInstance nodeInstance : this.getNodeInstances(recursive)) {
            if (nodeInstance.getId() != nodeInstanceId) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<String> getActiveNodeIds() {
        ArrayList<String> result = new ArrayList<String>();
        this.addActiveNodeIds(this, result);
        return result;
    }

    private void addActiveNodeIds(org.kie.api.runtime.process.NodeInstanceContainer container, List<String> result) {
        for (org.kie.api.runtime.process.NodeInstance nodeInstance : container.getNodeInstances()) {
            result.add(((NodeImpl)nodeInstance.getNode()).getUniqueId());
            if (!(nodeInstance instanceof org.kie.api.runtime.process.NodeInstanceContainer)) continue;
            this.addActiveNodeIds((org.kie.api.runtime.process.NodeInstanceContainer)nodeInstance, result);
        }
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId || nodeInstance.getLevel() != this.getCurrentLevel()) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public List<NodeInstance> getNodeInstances(long nodeId, List<NodeInstance> currentView) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : currentView) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        return this.getNodeInstance(node, true);
    }

    public NodeInstance getNodeInstance(Node node, boolean wrap) {
        Node actualNode = node;
        if (node instanceof AsyncEventNode) {
            actualNode = ((AsyncEventNode)node).getActualNode();
        } else if (wrap && this.useAsync(node)) {
            actualNode = new AsyncEventNode(node);
        }
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.getInstance(this.getKnowledgeRuntime().getEnvironment()).getProcessNodeInstanceFactory(actualNode);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(actualNode, this, this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        if (nodeInstance.isInversionOfControl()) {
            this.getKnowledgeRuntime().insert((Object)nodeInstance);
        }
        return nodeInstance;
    }

    public long getNodeInstanceCounter() {
        return this.singleNodeInstanceCounter.get();
    }

    public void internalSetNodeInstanceCounter(long nodeInstanceCounter) {
        this.singleNodeInstanceCounter = new AtomicLong(nodeInstanceCounter);
    }

    public AtomicLong internalGetNodeInstanceCounter() {
        return this.singleNodeInstanceCounter;
    }

    public org.kie.api.definition.process.WorkflowProcess getWorkflowProcess() {
        return (org.kie.api.definition.process.WorkflowProcess)this.getProcess();
    }

    public Object getVariable(String name) {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances != null && variableScopeInstances.size() == 1) {
                for (ContextInstance contextInstance : variableScopeInstances) {
                    Object value = ((VariableScopeInstance)contextInstance).getVariable(name);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariable(name);
    }

    public Object getVariable(String name, List<ContextInstance> variableScopeInstances) {
        if (variableScopeInstances != null) {
            for (ContextInstance contextInstance : variableScopeInstances) {
                Object value = ((VariableScopeInstance)contextInstance).getVariable(name);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ContextInstance contextInstance : variableScopeInstances) {
                Map<String, Object> variables = ((VariableScopeInstance)contextInstance).getVariables();
                result.putAll(variables);
            }
            return result;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariables();
    }

    public void setVariable(String name, Object value) {
        VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcess()).getDefaultContext("VariableScope");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            throw new IllegalArgumentException("No variable scope found.");
        }
        variableScopeInstance.setVariable(name, variableScope.validateVariable(this.getProcessName(), name, value));
    }

    @Override
    public void setState(int state, String outcome, Object faultData) {
        this.faultData = faultData;
        this.setState(state, outcome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(int state, String outcome) {
        if (this.getMetaData().containsKey("SUB_PROCESS_INTERRUPTION") || this.getState() == 2 || this.getState() == 3) {
            return;
        }
        if (state == 2 || state == 3) {
            if (this.slaCompliance == 1) {
                this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : (state == 2 ? 2 : 4);
            }
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeProcessCompleted((ProcessInstance)this, (KieRuntime)kruntime);
            super.setState(state, outcome);
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                if (state == 2) {
                    nodeInstance.cancel(NodeInstance.CancelType.OBSOLETE);
                    continue;
                }
                nodeInstance.cancel();
            }
            if (this.slaTimerId > -1L) {
                processRuntime.getTimerManager().cancelTimer(this.getId(), this.slaTimerId);
                logger.debug("SLA Timer {} has been canceled", (Object)this.slaTimerId);
            }
            this.removeEventListeners();
            processRuntime.getProcessInstanceManager().removeProcessInstance(this);
            processRuntime.getProcessEventSupport().fireAfterProcessCompleted((ProcessInstance)this, (KieRuntime)kruntime);
            if (this.isSignalCompletion()) {
                RuntimeManager manager = (RuntimeManager)kruntime.getEnvironment().get("RuntimeManager");
                if (this.getParentProcessInstanceId() > 0L && manager != null) {
                    ProcessInstanceIdContext context = ProcessInstanceIdContext.get((Long)this.getParentProcessInstanceId());
                    String caseId = (String)kruntime.getEnvironment().get("CaseId");
                    if (caseId != null) {
                        context = CaseContext.get((String)caseId);
                    }
                    RuntimeEngine runtime = null;
                    try {
                        runtime = manager.getRuntimeEngine((Context)context);
                        KieSession managedkruntime = runtime.getKieSession();
                        managedkruntime.signalEvent("processInstanceCompleted:" + this.getId(), (Object)this);
                    }
                    catch (SessionNotFoundException e) {
                        logger.debug("Could not found find parent process instance id {} for signaling completion", context.getContextId());
                    }
                    finally {
                        if (runtime != null) {
                            manager.disposeRuntimeEngine(runtime);
                        }
                    }
                } else {
                    processRuntime.getSignalManager().signalEvent("processInstanceCompleted:" + this.getId(), this);
                }
            }
        } else {
            super.setState(state, outcome);
        }
    }

    @Override
    public void setState(int state) {
        this.setState(state, null);
    }

    @Override
    public void disconnect() {
        this.removeEventListeners();
        this.unregisterExternalEventNodeListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
        super.disconnect();
    }

    @Override
    public void reconnect() {
        this.validate();
        super.reconnect();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
        this.registerExternalEventNodeListeners();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcessId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String trigger) {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            Node[] nodes;
            this.startDate = new Date();
            this.registerExternalEventNodeListeners();
            for (Node node : nodes = this.getNodeContainer().getNodes()) {
                Map<Timer, DroolsAction> timers;
                if (!(node instanceof EventSubProcessNode) || (timers = ((EventSubProcessNode)node).getTimers()) == null || timers.isEmpty()) continue;
                EventSubProcessNodeInstance eventSubprocess = (EventSubProcessNodeInstance)this.getNodeInstance(node);
                eventSubprocess.trigger(null, "DROOLS_DEFAULT");
            }
            super.start(trigger);
        }
    }

    @Override
    public void configureSLA() {
        TimerInstance timer;
        String slaDueDateExpression = (String)this.getProcess().getMetaData().get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = this.configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for process instance {} is PENDING with due date {}", (Object)this.getId(), (Object)this.slaDueDate);
        }
    }

    public TimerInstance configureSLATimer(String slaDueDateExpression) {
        return this.configureSLATimer(slaDueDateExpression, null);
    }

    public TimerInstance configureSLATimer(String slaDueDateExpression, String timerName) {
        return this.configureTimer(slaDueDateExpression, timerName, this.useTimerSLATracking());
    }

    public TimerInstance configureTimer(String timerExpression, String timerName, boolean trackTimer) {
        String timerResolvedExpression = this.resolveVariable(timerExpression);
        if (timerResolvedExpression == null || timerResolvedExpression.trim().isEmpty()) {
            logger.debug("Timer due date expression resolved to no value '{}'", (Object)timerResolvedExpression);
            return null;
        }
        logger.debug("Configure timer {} due date is set to {}", (Object)timerName, (Object)timerResolvedExpression);
        InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
        long duration = -1L;
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            duration = businessCalendar.calculateBusinessTimeAsDuration(timerResolvedExpression);
        } else {
            duration = DateTimeUtils.parseDuration(timerResolvedExpression);
        }
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setId(-1L);
        timerInstance.setDelay(duration);
        timerInstance.setPeriod(0L);
        timerInstance.setName(timerName);
        if (trackTimer) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getTimerManager().registerTimer(timerInstance, this);
        }
        return timerInstance;
    }

    public void cancelTimer(long timerId) {
        ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getTimerManager().cancelTimer(this.getId(), timerId);
    }

    protected void registerExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (node instanceof EventNode && "external".equals(((EventNode)node).getScope())) {
                String eventType = ((EventNode)node).getType();
                this.addEventListener(eventType, DummyEventListener.EMPTY_EVENT_LISTENER, true);
                if (!this.isVariableExpression(eventType)) continue;
                this.addEventListener(this.resolveVariable(eventType), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                continue;
            }
            if (node instanceof EventSubProcessNode) {
                List<String> events = ((EventSubProcessNode)node).getEvents();
                for (String type : events) {
                    this.addEventListener(type, DummyEventListener.EMPTY_EVENT_LISTENER, true);
                    if (!this.isVariableExpression(type)) continue;
                    this.addEventListener(this.resolveVariable(type), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                }
                continue;
            }
            if (!(node instanceof DynamicNode) || ((DynamicNode)node).getActivationEventName() == null) continue;
            this.addEventListener(((DynamicNode)node).getActivationEventName(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
        }
        if (this.getWorkflowProcess().getMetaData().containsKey("Compensation")) {
            this.addEventListener("Compensation", new CompensationEventListener(this), true);
        }
    }

    private void unregisterExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            String eventType = ((EventNode)node).getType();
            this.removeEventListener(eventType, DummyEventListener.EMPTY_EVENT_LISTENER, true);
            if (!this.isVariableExpression(eventType)) continue;
            this.removeEventListener(this.resolveVariable(eventType), DummyEventListener.EMPTY_EVENT_LISTENER, true);
        }
    }

    private void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated((ProcessInstance)this, (KieRuntime)kruntime);
            logger.debug("SLA violated on process instance {}", (Object)this.getId());
            this.slaCompliance = 3;
            this.slaTimerId = -1L;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated((ProcessInstance)this, (KieRuntime)kruntime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        logger.debug("Signal {} received with data {} in process instance {}", new Object[]{type, event, this.getId()});
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            TimerInstance timer;
            if (this.getState() != 1) {
                return;
            }
            if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId() == this.slaTimerId) {
                this.handleSLAViolation();
                return;
            }
            if ("slaViolation".equals(type)) {
                this.handleSLAViolation();
                return;
            }
            try {
                this.activatingNodeIds = new ArrayList<String>();
                List<EventListener> listeners = this.eventListeners.get(type);
                if (listeners != null) {
                    for (EventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                if ((listeners = this.externalEventListeners.get(type)) != null) {
                    for (EventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                this.signal(this, node -> this.getNodeInstance((Node)node), () -> this.getWorkflowProcess().getNodes(), type, event);
                if (((WorkflowProcess)this.getWorkflowProcess()).isDynamic()) {
                    for (Node node2 : this.getWorkflowProcess().getNodes()) {
                        if (!type.equals(node2.getName()) || !node2.getIncomingConnections().isEmpty()) continue;
                        NodeInstance nodeInstance = this.getNodeInstance(node2);
                        if (event != null) {
                            HashMap<String, Object> dynamicParams = new HashMap<String, Object>();
                            if (event instanceof Map) {
                                dynamicParams.putAll((Map)event);
                            } else {
                                dynamicParams.put("Data", event);
                            }
                            nodeInstance.setDynamicParameters(dynamicParams);
                        }
                        nodeInstance.trigger(null, "DROOLS_DEFAULT");
                    }
                }
            }
            finally {
                if (this.activatingNodeIds != null) {
                    this.activatingNodeIds.clear();
                    this.activatingNodeIds = null;
                }
            }
        }
    }

    private void signal(org.kie.api.runtime.process.NodeInstanceContainer container, Function<Node, NodeInstance> nodeInstanceSupplier, Supplier<Node[]> resolveNodes, String type, Object event) {
        List<NodeInstance> currentView = container.getNodeInstances().stream().map(e -> (NodeInstance)e).collect(Collectors.toList());
        for (Node node : resolveNodes.get()) {
            ExtendedNodeInstanceImpl eventNodeInstance;
            if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)node).acceptsEvent(type, event, this.getEventFilterResolver(this, node, currentView))) continue;
            if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                eventNodeInstance = (EventNodeInstance)nodeInstanceSupplier.apply(node);
                ((EventNodeInstance)eventNodeInstance).signalEvent(type, event);
                continue;
            }
            if (node instanceof EventSubProcessNode && this.resolveVariables(((EventSubProcessNode)node).getEvents()).contains(type)) {
                eventNodeInstance = (EventSubProcessNodeInstance)nodeInstanceSupplier.apply(node);
                ((EventSubProcessNodeInstance)eventNodeInstance).signalEvent(type, event);
            }
            if (node instanceof DynamicNode && type.equals(((DynamicNode)node).getActivationEventName())) {
                DynamicNodeInstance dynamicNodeInstance = (DynamicNodeInstance)nodeInstanceSupplier.apply(node);
                dynamicNodeInstance.signalEvent(type, event);
                continue;
            }
            List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
            if (nodeInstances == null || nodeInstances.isEmpty()) continue;
            for (NodeInstance nodeInstance : nodeInstances) {
                ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
            }
        }
    }

    public Function<String, Object> getEventFilterResolver(org.kie.api.runtime.process.NodeInstanceContainer container, Node node, List<NodeInstance> currentView) {
        if (node instanceof DynamicNode) {
            return varExpresion -> {
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                if (nodeInstances != null && !nodeInstances.isEmpty()) {
                    StringBuilder st = new StringBuilder();
                    for (NodeInstance ni : nodeInstances) {
                        String result = this.resolveVariable((String)varExpresion, (VariableResolverFactory)new NodeInstanceResolverFactory(ni));
                        st.append(result).append("###");
                    }
                    return st.toString();
                }
                NodeInstanceImpl instance = (NodeInstanceImpl)this.getNodeInstance(node.getId(), true);
                if (instance != null) {
                    return instance.getVariable((String)varExpresion);
                }
                return null;
            };
        }
        if (node instanceof BoundaryEventNode) {
            return varExpresion -> {
                final Function<String, Object> getScopedVariable = container instanceof CompositeContextNodeInstance ? name -> this.getVariable((String)name, ((CompositeContextNodeInstance)container).getContextInstances("VariableScope")) : (container instanceof WorkflowProcessInstanceImpl ? name -> ((WorkflowProcessInstanceImpl)container).getVariable((String)name) : null);
                Object value = getScopedVariable.apply((String)varExpresion);
                if (value != null) {
                    return value;
                }
                ImmutableDefaultFactory resolverFactory = new ImmutableDefaultFactory(){

                    public boolean isResolveable(String varName) {
                        return getScopedVariable.apply(varName) != null;
                    }

                    public VariableResolver getVariableResolver(String varName) {
                        return new SimpleValueResolver(getScopedVariable.apply(varName));
                    }
                };
                return this.resolveExpressionVariable((String)varExpresion, (VariableResolverFactory)resolverFactory).orElse(null);
            };
        }
        if (node instanceof ForEachNode) {
            return varExpression -> {
                try {
                    ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)this.getNodeInstanceByNodeId(node.getId(), true);
                    if (forEachNodeInstance == null) {
                        return new Object[0];
                    }
                    List data = forEachNodeInstance.getNodeInstances().stream().filter(e -> e instanceof CompositeContextNodeInstance).map(e -> (CompositeContextNodeInstance)e).collect(Collectors.toList());
                    ArrayList outcome = new ArrayList();
                    for (CompositeContextNodeInstance nodeInstance : data) {
                        Object resolvedValue = this.resolveExpressionVariable((String)varExpression, (VariableResolverFactory)new NodeInstanceResolverFactory(nodeInstance)).orElse(null);
                        if (resolvedValue == null) continue;
                        outcome.add(resolvedValue);
                    }
                    return outcome.toArray();
                }
                catch (Throwable t) {
                    return new Object[0];
                }
            };
        }
        if (node instanceof EventSubProcessNode || node instanceof StateNode) {
            return varName -> this.resolveExpressionVariable((String)varName, (VariableResolverFactory)new ProcessInstanceResolverFactory(this)).orElse(null);
        }
        if (node instanceof CompositeContextNode) {
            return varExpression -> {
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                ArrayList outcome = new ArrayList();
                if (nodeInstances != null && !nodeInstances.isEmpty()) {
                    for (NodeInstance nodeInstance : nodeInstances) {
                        Object resolvedValue = this.resolveExpressionVariable((String)varExpression, (VariableResolverFactory)new NodeInstanceResolverFactory(nodeInstance)).orElse(null);
                        if (resolvedValue == null) continue;
                        outcome.add(resolvedValue);
                    }
                }
                return outcome.toArray();
            };
        }
        return varName -> this.resolveExpressionVariable((String)varName, (VariableResolverFactory)new ProcessInstanceResolverFactory(this)).orElse(null);
    }

    private void validate() {
        InternalRuntimeManager manager = (InternalRuntimeManager)this.getKnowledgeRuntime().getEnvironment().get("RuntimeManager");
        if (manager != null && this.hasDeploymentId() && !manager.getIdentifier().equals(this.getDeploymentId())) {
            throw new IllegalStateException("Process instance " + this.getId() + " is owned by another deployment " + this.getDeploymentId() + " != " + manager.getIdentifier());
        }
    }

    protected List<String> resolveVariables(List<String> events) {
        return events.stream().map(this::resolveVariable).collect(Collectors.toList());
    }

    private String resolveVariable(String s) {
        return this.resolveVariable(s, (VariableResolverFactory)new ProcessInstanceResolverFactory(this));
    }

    private String resolveVariable(String s, VariableResolverFactory factory) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            Optional<Object> resolvedValue = this.resolveExpressionVariable(paramName, factory);
            replacements.put(paramName, resolvedValue.orElse(paramName));
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", replacement.getValue().toString());
        }
        return s;
    }

    private Optional<Object> resolveExpressionVariable(String paramName, VariableResolverFactory factory) {
        try {
            if (factory.isResolveable(paramName)) {
                return Optional.of(factory.getVariableResolver(paramName).getValue());
            }
            return Optional.ofNullable(MVELSafeHelper.getEvaluator().eval(paramName, factory));
        }
        catch (Throwable t) {
            logger.error("Could not find variable scope for variable {}", (Object)paramName);
            return Optional.empty();
        }
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List listeners = eventListeners.computeIfAbsent(type, listenerType -> {
            CopyOnWriteArrayList newListenersList = new CopyOnWriteArrayList();
            if (external) {
                ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().addEventListener((String)listenerType, (EventListener)this);
            }
            return newListenersList;
        });
        listeners.add(listener);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                eventListeners.remove(type);
                if (external) {
                    ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, (EventListener)this);
                }
            }
        } else {
            eventListeners.remove(type);
        }
    }

    private void removeEventListeners() {
        for (String type : this.externalEventListeners.keySet()) {
            ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, (EventListener)this);
        }
    }

    @Override
    public String[] getEventTypes() {
        return this.externalEventListeners.keySet().stream().map(this::resolveVariable).collect(Collectors.toList()).toArray(new String[this.externalEventListeners.size()]);
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null) {
            boolean isForCompensation;
            Object compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation");
            boolean bl = isForCompensation = compensationBoolObj != null && (Boolean)compensationBoolObj != false;
            if (isForCompensation) {
                return;
            }
        }
        if (nodeInstance instanceof FaultNodeInstance || nodeInstance instanceof EndNodeInstance || ((WorkflowProcess)this.getWorkflowProcess()).isDynamic() || nodeInstance instanceof CompositeNodeInstance) {
            if (((WorkflowProcess)this.getProcess()).isAutoComplete() && this.canComplete()) {
                this.setState(2);
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection is not supported.");
        }
    }

    private boolean canComplete() {
        if (this.nodeInstances.isEmpty()) {
            return true;
        }
        int eventSubprocessCounter = 0;
        for (NodeInstance nodeInstance : this.nodeInstances) {
            Node node = nodeInstance.getNode();
            if (node instanceof EventSubProcessNode) {
                if (!((EventSubProcessNodeInstance)nodeInstance).getNodeInstances().isEmpty()) continue;
                ++eventSubprocessCounter;
                continue;
            }
            return false;
        }
        return eventSubprocessCounter == this.nodeInstances.size();
    }

    public void addCompletedNodeId(String uniqueId) {
        this.completedNodeIds.add(uniqueId.intern());
    }

    public List<String> getCompletedNodeIds() {
        return new ArrayList<String>(this.completedNodeIds);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public Map<String, Integer> getIterationLevels() {
        return this.iterationLevels;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public void addActivatingNodeId(String uniqueId) {
        if (this.activatingNodeIds == null) {
            return;
        }
        this.activatingNodeIds.add(uniqueId.intern());
    }

    public List<String> getActivatingNodeIds() {
        if (this.activatingNodeIds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.activatingNodeIds);
    }

    @Override
    public Object getFaultData() {
        return this.faultData;
    }

    @Override
    public boolean isSignalCompletion() {
        return this.signalCompletion;
    }

    @Override
    public void setSignalCompletion(boolean signalCompletion) {
        this.signalCompletion = signalCompletion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCorrelationKey() {
        if (this.correlationKey == null && this.getMetaData().get("CorrelationKey") != null) {
            this.correlationKey = ((CorrelationKey)this.getMetaData().get("CorrelationKey")).toExternalForm();
        }
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void internalSetStartDate(Date startDate) {
        if (this.startDate == null) {
            this.startDate = startDate;
        }
    }

    protected boolean hasDeploymentId() {
        return this.deploymentId != null && !this.deploymentId.isEmpty();
    }

    protected boolean useAsync(Node node) {
        if (!(node instanceof EventSubProcessNode) && (node instanceof ActionNode || node instanceof StateBasedNode || node instanceof EndNode)) {
            boolean asyncMode = Boolean.parseBoolean((String)node.getMetaData().get("customAsync"));
            if (asyncMode) {
                return asyncMode;
            }
            return Boolean.parseBoolean((String)this.getKnowledgeRuntime().getEnvironment().get("AsyncMode"));
        }
        return false;
    }

    protected boolean useTimerSLATracking() {
        String mode = (String)this.getKnowledgeRuntime().getEnvironment().get("SLATimerMode");
        if (mode == null) {
            return true;
        }
        return Boolean.parseBoolean(mode);
    }

    @Override
    public int getSlaCompliance() {
        return this.slaCompliance;
    }

    public void internalSetSlaCompliance(int slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    @Override
    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void internalSetSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public Long getSlaTimerId() {
        return this.slaTimerId;
    }

    public void internalSetSlaTimerId(Long slaTimerId) {
        this.slaTimerId = slaTimerId;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    @Override
    public AgendaFilter getAgendaFilter() {
        return this.agendaFilter;
    }

    @Override
    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }
}

