/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;

public class SolverBuilder {
    static final String CONFIGURED_THREAD_FACTORY_CLASS_NOT_FOUND_ERROR = "An error was produced during threadFactoryClass initialization, class: %s was not found.";
    static final String CONFIGURED_THREAD_FACTORY_CLASS_MUST_IMPLEMENT_THREAD_FACTORY = "An error was produced during threadFactoryClass initialization, class: %s must implement: %s.";
    private SolverDef solverDef;
    private KieServerRegistry registry;

    private SolverBuilder() {
    }

    public static SolverBuilder create() {
        return new SolverBuilder();
    }

    public SolverBuilder solverDef(SolverDef solverDef) {
        this.solverDef = solverDef;
        return this;
    }

    public SolverBuilder registry(KieServerRegistry registry) {
        this.registry = registry;
        return this;
    }

    public Solver<TaskAssigningSolution> build() {
        if (StringUtils.isEmpty((CharSequence)this.solverDef.getContainerId())) {
            return this.buildFromResource();
        }
        return this.buildFromContainer();
    }

    private Solver<TaskAssigningSolution> buildFromResource() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverDef.getSolverConfigResource());
        if (StringUtils.isNotEmpty((CharSequence)this.solverDef.getMoveThreadCount())) {
            solverConfig.setMoveThreadCount(this.solverDef.getMoveThreadCount());
            if (this.solverDef.getMoveThreadBufferSize() >= 1) {
                solverConfig.setMoveThreadBufferSize(solverConfig.getMoveThreadBufferSize());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.solverDef.getThreadFactoryClass())) {
            Class<?> threadFactoryClass;
            try {
                threadFactoryClass = Class.forName(this.solverDef.getThreadFactoryClass());
            }
            catch (ClassNotFoundException e) {
                throw new SolverBuilderException(String.format(CONFIGURED_THREAD_FACTORY_CLASS_NOT_FOUND_ERROR, this.solverDef.getThreadFactoryClass()));
            }
            if (!ThreadFactory.class.isAssignableFrom(threadFactoryClass)) {
                throw new SolverBuilderException(String.format(CONFIGURED_THREAD_FACTORY_CLASS_MUST_IMPLEMENT_THREAD_FACTORY, this.solverDef.getThreadFactoryClass(), ThreadFactory.class.getName()));
            }
            solverConfig.setThreadFactoryClass(threadFactoryClass);
        }
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        return solverFactory.buildSolver();
    }

    private Solver<TaskAssigningSolution> buildFromContainer() {
        KieContainerInstanceImpl containerInstance = this.registry.getContainer(this.solverDef.getContainerId());
        if (containerInstance == null) {
            throw new SolverBuilderException("Container " + this.solverDef.getContainerId() + " was not found un current registry. No solvers can be created for this container");
        }
        if (containerInstance.getStatus() != KieContainerStatus.STARTED) {
            throw new SolverBuilderException("Container " + this.solverDef.getContainerId() + " must be in " + KieContainerStatus.STARTED + " status for creating solvers, but current status is: " + containerInstance.getStatus());
        }
        SolverFactory solverFactory = SolverFactory.createFromKieContainerXmlResource((KieContainer)containerInstance.getKieContainer(), (String)this.solverDef.getSolverConfigResource());
        return solverFactory.buildSolver();
    }

    public static class SolverBuilderException
    extends RuntimeException {
        public SolverBuilderException(String message) {
            super(message);
        }
    }
}

