/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.List;
import java.util.concurrent.Semaphore;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.RunnableBase;
import org.kie.server.services.taskassigning.planning.SolverBuilder;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverExecutor
extends RunnableBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverExecutor.class);
    private SolverDef solverDef;
    private KieServerRegistry registry;
    private Solver<TaskAssigningSolution> solver;
    private TaskAssigningSolution solution;
    private SolverEventListener<TaskAssigningSolution> eventListener;
    private final Semaphore startPermit = new Semaphore(0);

    public SolverExecutor(SolverDef solverDef, KieServerRegistry registry, SolverEventListener<TaskAssigningSolution> eventListener) {
        PortablePreconditions.checkNotNull((String)"solverDef", (Object)solverDef);
        PortablePreconditions.checkNotNull((String)"registry", (Object)registry);
        PortablePreconditions.checkNotNull((String)"eventListener", eventListener);
        this.solverDef = solverDef;
        this.registry = registry;
        this.eventListener = eventListener;
    }

    public void start(TaskAssigningSolution solution) {
        PortablePreconditions.checkNotNull((String)"solution", (Object)solution);
        if (!this.status.compareAndSet(RunnableBase.Status.STOPPED, RunnableBase.Status.STARTING)) {
            throw new SolverExecutorException("SolverExecutor start method can only be invoked when the status is STOPPED");
        }
        this.solution = solution;
        try {
            this.solver = this.buildSolver(this.solverDef, this.registry);
        }
        catch (Exception e) {
            this.status.set(RunnableBase.Status.STOPPED);
            throw new SolverExecutorException(e.getMessage(), e);
        }
        this.solver.addEventListener(event -> {
            if (this.isAlive() && this.isStarted()) {
                this.eventListener.bestSolutionChanged(event);
            }
        });
        this.startPermit.release();
    }

    protected Solver<TaskAssigningSolution> buildSolver(SolverDef solverDef, KieServerRegistry registry) {
        return SolverBuilder.create().solverDef(solverDef).registry(registry).build();
    }

    public boolean isStarted() {
        return this.status.get() == RunnableBase.Status.STARTED;
    }

    public boolean isStopped() {
        return this.status.get() == RunnableBase.Status.STOPPED;
    }

    public void stop() {
        if (!this.isDestroyed()) {
            RunnableBase.Status previousStatus = this.status.getAndSet(RunnableBase.Status.STOPPING);
            if (previousStatus == RunnableBase.Status.STARTED) {
                this.solver.terminateEarly();
            } else {
                this.status.set(RunnableBase.Status.STOPPED);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.status.getAndSet(RunnableBase.Status.DESTROYED) == RunnableBase.Status.STARTED) {
            this.solver.terminateEarly();
        } else {
            this.startPermit.release();
        }
    }

    public void addProblemFactChanges(List<ProblemFactChange<TaskAssigningSolution>> changes) {
        if (!this.isStarted()) {
            throw new SolverExecutorException("SolverExecutor has not been started. Be sure it's started and not stopped or destroyed prior to executing this method");
        }
        this.solver.addProblemFactChanges(changes);
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                LOGGER.debug("SolverExecutor is waiting for a start(solution) method invocation for starting the Solver.");
                this.startPermit.acquire();
                LOGGER.debug("SolverExecutor, the Solver will be started.");
                if (!this.isAlive() || !this.status.compareAndSet(RunnableBase.Status.STARTING, RunnableBase.Status.STARTED)) continue;
                this.solver.solve((Object)this.solution);
                if (this.isAlive()) {
                    this.status.set(RunnableBase.Status.STOPPED);
                    LOGGER.debug("Solver has been stopped. It can be restarted with the start(solution) method.");
                    continue;
                }
                LOGGER.debug("SolverExecutor has been destroyed. No more invocations can be done on this instance.");
            }
            catch (InterruptedException e) {
                super.destroy();
                Thread.currentThread().interrupt();
                LOGGER.error("SolverExecutor was interrupted.", (Throwable)e);
            }
        }
        super.destroy();
        LOGGER.debug("SolverExecutor finished.");
    }

    public static class SolverExecutorException
    extends RuntimeException {
        public SolverExecutorException(String message) {
            super(message);
        }

        public SolverExecutorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

