/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.util;

import java.util.Iterator;
import java.util.List;

public class IndexedElement<T> {
    private T element;
    private int index;
    private boolean pinned;

    public IndexedElement(T element, int index, boolean pinned) {
        this.element = element;
        this.index = index;
        this.pinned = pinned;
    }

    public T getElement() {
        return this.element;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public static <T> void addInOrder(List<IndexedElement<T>> indexedElements, IndexedElement<T> element) {
        boolean pinned = element.isPinned();
        int index = element.getIndex();
        int insertIndex = 0;
        Iterator<IndexedElement<T>> it = indexedElements.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            IndexedElement<T> currentElement = it.next();
            if (pinned && currentElement.isPinned()) {
                found = index >= 0 && (currentElement.getIndex() < 0 || index < currentElement.getIndex());
            } else if (pinned && !currentElement.isPinned()) {
                found = true;
            } else if (!pinned && !currentElement.isPinned()) {
                found = index >= 0 && (currentElement.getIndex() < 0 || index < currentElement.getIndex());
            }
            insertIndex = !found ? insertIndex + 1 : insertIndex;
        }
        indexedElements.add(insertIndex, element);
    }
}

