/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.api.model.taskassigning.LocalDateTimeValue;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.taskassigning.runtime.TaskAssigningRuntimeServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssigningRuntimeKieServerExtension
implements KieServerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningRuntimeKieServerExtension.class);
    public static final String EXTENSION_NAME = "TaskAssigningRuntime";
    static final String CAPABILITY_TASK_ASSIGNING_RUNTIME = "TaskAssigningRuntime";
    static final int EXTENSION_START_ORDER = 1000;
    static final String TASK_ASSIGNING_QUERY_DEFINITIONS_RESOURCE = "/task-assigning-query-definitions.json";
    private KieServerRegistry registry;
    private TaskAssigningRuntimeServiceBase taskAssigningRuntimeServiceBase;
    private QueryService queryService = null;
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return Boolean.FALSE.toString().equals(System.getProperty("org.kie.server.taskAssigning.runtime.ext.disabled", Boolean.TRUE.toString()));
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.registry = registry;
        registry.getExtraClasses().add(LocalDateTimeValue.class);
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        if (jbpmExtension == null) {
            throw new KieServicesException("jBPM extension is required for the task assigning api to work.");
        }
        this.configureServices(kieServer, registry);
        this.services.add(this.taskAssigningRuntimeServiceBase);
        try {
            this.registerQueries();
        }
        catch (Exception e) {
            throw new KieServicesException(String.format("An error was produced during extension queries initialization, error: %s", e.getMessage()), (Throwable)e);
        }
        this.initialized = true;
    }

    private void configureServices(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        List jbpmServices = jbpmExtension.getServices();
        UserTaskService userTaskService = null;
        for (Object object : jbpmServices) {
            if (object == null) continue;
            if (UserTaskService.class.isAssignableFrom(object.getClass())) {
                userTaskService = (UserTaskService)object;
                continue;
            }
            if (!QueryService.class.isAssignableFrom(object.getClass())) continue;
            this.queryService = (QueryService)object;
        }
        this.taskAssigningRuntimeServiceBase = new TaskAssigningRuntimeServiceBase(kieServer, registry, userTaskService, this.queryService);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] componentServices = new Object[]{this.taskAssigningRuntimeServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents("TaskAssigningRuntime", type, componentServices));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.taskAssigningRuntimeServiceBase.getClass())) {
            return (T)this.taskAssigningRuntimeServiceBase;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "TaskAssigningRuntime";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return "TaskAssigningRuntime";
    }

    public Integer getStartOrder() {
        return 1000;
    }

    public String toString() {
        return "TaskAssigningRuntime KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("toTaskId", -1L);
            this.taskAssigningRuntimeServiceBase.executeFindTasksQuery(params);
            if (report) {
                messages.add(new Message(Severity.INFO, "TaskAssigningRuntime is alive"));
            }
        }
        catch (Exception e) {
            messages.add(new Message(Severity.ERROR, String.format("TaskAssigningRuntime failed due to: %s", e.getMessage())));
        }
        return messages;
    }

    private void registerQueries() throws IOException {
        try (InputStream stream = this.getClass().getResourceAsStream(TASK_ASSIGNING_QUERY_DEFINITIONS_RESOURCE);){
            String queriesString;
            if (stream == null) {
                throw new FileNotFoundException("Extension queries resource was not found: /task-assigning-query-definitions.json");
            }
            Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
            org.kie.server.api.model.definition.QueryDefinition[] queries = (org.kie.server.api.model.definition.QueryDefinition[])marshaller.unmarshall(queriesString = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), org.kie.server.api.model.definition.QueryDefinition[].class);
            if (queries == null || queries.length == 0) {
                LOGGER.info("No queries were found");
                return;
            }
            this.registerQueries(queries);
        }
    }

    private void registerQueries(org.kie.server.api.model.definition.QueryDefinition[] queries) {
        for (org.kie.server.api.model.definition.QueryDefinition query : queries) {
            SqlQueryDefinition sqlQuery = new SqlQueryDefinition(query.getName(), query.getSource());
            sqlQuery.setTarget(QueryDefinition.Target.valueOf((String)query.getTarget()));
            sqlQuery.setExpression(query.getExpression());
            this.queryService.replaceQuery((QueryDefinition)sqlQuery);
        }
    }
}

