/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import org.nuxeo.android.activities.BaseNuxeoActivity;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.network.NuxeoNetworkStatus;
import org.nuxeo.android.upload.FileUploader;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.cache.DeferredUpdateManager;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheManager;
import org.nuxeo.ecm.automation.client.cache.TransientStateManager;

public abstract class AbstractNetworkSettingsActivity
extends BaseNuxeoActivity {
    protected BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context ctx, Intent intent) {
            AbstractNetworkSettingsActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AbstractNetworkSettingsActivity.this.updateOfflineDisplay(AbstractNetworkSettingsActivity.this.getNuxeoContext().getNetworkStatus());
                }
            });
        }
    };

    @Override
    protected void onResume() {
        this.registerReceiver(this.receiver, new IntentFilter("NuxeoServerConnectivityChanged"));
        this.refreshAll();
        super.onResume();
    }

    protected void onPause() {
        this.unregisterReceiver(this.receiver);
        super.onPause();
    }

    protected void resetNetworkStatus(final Runnable afterReset) {
        Runnable tester = new Runnable(){

            @Override
            public void run() {
                AbstractNetworkSettingsActivity.this.getNuxeoContext().getNetworkStatus().reset();
                if (afterReset != null) {
                    AbstractNetworkSettingsActivity.this.runOnUiThread(afterReset);
                }
            }
        };
        new Thread(tester).start();
    }

    protected void refreshAll() {
        this.updateOfflineDisplay(this.getNuxeoContext().getNetworkStatus());
        this.fireUpdateCacheInfoDisplay();
    }

    protected void fireUpdateCacheInfoDisplay() {
        AndroidAutomationClient client = this.getAutomationClient();
        this.updateCacheInfoDisplay(client.getResponseCacheManager(), client.getDeferredUpdatetManager(), client.getBlobStoreManager(), client.getFileUploader(), client.getTransientStateManager());
    }

    protected void resetNetworkStatusAndRefresh() {
        this.resetNetworkStatus(new Runnable(){

            @Override
            public void run() {
                AbstractNetworkSettingsActivity.this.refreshAll();
            }
        });
    }

    protected void executePendingUpdates() {
        DeferredUpdateManager dum = this.getAutomationClient().getDeferredUpdatetManager();
        if (dum.getPendingRequestCount() > 0L) {
            dum.executePendingRequests(this.getNuxeoSession(), new Handler(){

                public void handleMessage(Message msg) {
                    AbstractNetworkSettingsActivity.this.refreshAll();
                    super.handleMessage(msg);
                }
            });
        }
    }

    protected abstract void updateOfflineDisplay(NuxeoNetworkStatus var1);

    protected abstract void updateCacheInfoDisplay(ResponseCacheManager var1, DeferredUpdateManager var2, BlobStoreManager var3, FileUploader var4, TransientStateManager var5);

    protected void flushResponseCache() {
        this.getAutomationClient().getResponseCacheManager().clear();
        this.fireUpdateCacheInfoDisplay();
    }

    protected void flushDeferredUpdateManager() {
        this.getAutomationClient().getDeferredUpdatetManager().purgePendingUpdates();
        this.getAutomationClient().getTransientStateManager().flushTransientState();
        this.fireUpdateCacheInfoDisplay();
    }

    protected void flushPendingUploads() {
        this.getAutomationClient().getFileUploader().purgePendingUploads();
        this.fireUpdateCacheInfoDisplay();
    }

    protected void flushBlobStore(String name) {
        this.getAutomationClient().getBlobStoreManager().getBlobStore(name).clear();
        this.fireUpdateCacheInfoDisplay();
    }

    protected void flushTransientState() {
        this.getAutomationClient().getTransientStateManager().flushTransientState();
        this.fireUpdateCacheInfoDisplay();
    }

    protected void goOffline(boolean offline) {
        this.getNuxeoContext().getNetworkStatus().setForceOffline(offline);
        this.updateOfflineDisplay(this.getNuxeoContext().getNetworkStatus());
    }
}

