/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.android.activities.BaseNuxeoActivity;
import org.nuxeo.android.config.NuxeoServerConfig;

public abstract class AbstractNuxeoSettingsActivity
extends BaseNuxeoActivity {
    protected boolean saveNuxeoPreferences(Map<String, Object> prefData) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
        SharedPreferences.Editor prefEditor = prefs.edit();
        for (String key : prefData.keySet()) {
            Object value = prefData.get(key);
            if (value instanceof String) {
                if (prefs.contains(key) && ((String)value).equals(prefs.getString(key, null))) continue;
                prefEditor.putString(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                if (((Boolean)value).equals(prefs.getBoolean(key, false))) continue;
                prefEditor.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                if (prefs.contains(key) && ((Long)value).equals(prefs.getLong(key, 0L))) continue;
                prefEditor.putLong(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                if (prefs.contains(key) && ((Float)value).equals(Float.valueOf(prefs.getFloat(key, 0.0f)))) continue;
                prefEditor.putFloat(key, ((Float)value).floatValue());
                continue;
            }
            if (!(value instanceof Integer) || prefs.contains(key) && ((Integer)value).equals(prefs.getInt(key, 0))) continue;
            prefEditor.putInt(key, ((Integer)value).intValue());
        }
        boolean committed = prefEditor.commit();
        return committed;
    }

    protected Map<String, Object> getNuxeoPreferences() {
        HashMap<String, Object> nxPrefs = new HashMap<String, Object>();
        NuxeoServerConfig serverConfig = this.getNuxeoContext().getServerConfig();
        nxPrefs.put("nuxeo.serverUrl", serverConfig.getServerBaseUrl());
        nxPrefs.put("nuxeo.login", serverConfig.getLogin());
        nxPrefs.put("nuxeo.password", serverConfig.getPassword());
        return nxPrefs;
    }
}

