/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.Toast;
import java.io.Serializable;
import org.nuxeo.android.activities.BaseNuxeoActivity;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.NuxeoLayout;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocumentStatus;
import org.nuxeo.ecm.automation.client.jaxrs.model.IdRef;

public abstract class BaseDocumentLayoutActivity
extends BaseNuxeoActivity {
    public static final String DOCUMENT = "document";
    public static final String MODE = "mode";
    public static final String FIRST_CALL = "first call";
    protected Document currentDocument;
    protected Intent callingIntent;
    protected boolean requireAsyncFetch = true;
    public static final int MNU_SWITCH_EDIT = 1000;
    public static final int MNU_SWITCH_VIEW = 1001;
    protected NuxeoLayout layout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.callingIntent = this.getIntent();
        Document currentDoc = this.getCurrentDocument();
        if (this.isCreateMode()) {
            this.requireAsyncFetch = false;
        } else if (currentDoc.getStatusFlag() != DocumentStatus.SYNCHRONIZED) {
            this.requireAsyncFetch = false;
        }
        if (this.isEditMode()) {
            this.setTitle("Edit " + currentDoc.getType() + " " + this.getCurrentDocument().getTitle());
        } else if (this.isCreateMode()) {
            this.setTitle("Create new " + currentDoc.getType());
        } else {
            this.setTitle("View " + currentDoc.getType() + " " + this.getCurrentDocument().getTitle());
        }
    }

    protected abstract ViewGroup getLayoutContainer();

    protected void buildLayout() {
        this.layout = this.getAutomationClient().getLayoutService().getLayout(this, this.getCurrentDocument(), this.getLayoutContainer(), this.getMode());
    }

    protected NuxeoLayout getLayout() {
        if (this.layout == null) {
            this.buildLayout();
        }
        return this.layout;
    }

    protected LayoutMode getMode() {
        return (LayoutMode)this.getIntent().getExtras().get(MODE);
    }

    protected boolean isCreateMode() {
        return this.getMode() == LayoutMode.CREATE;
    }

    protected boolean isEditMode() {
        return this.getMode() == LayoutMode.EDIT;
    }

    protected Document getCurrentDocument() {
        if (this.currentDocument == null) {
            this.currentDocument = (Document)this.getIntent().getExtras().get(DOCUMENT);
        }
        return this.currentDocument;
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        this.currentDocument = (Document)data;
        if (this.layout == null) {
            Toast.makeText((Context)this, (CharSequence)"Unable to get Layout", (int)0).show();
        } else {
            this.layout.refreshFromDocument(this.currentDocument);
            Toast.makeText((Context)this, (CharSequence)"Refreshed document", (int)0).show();
        }
        this.requireAsyncFetch = false;
    }

    @Override
    protected Object retrieveNuxeoData() throws Exception {
        Document refreshedDocument = this.getNuxeoContext().getDocumentManager().getDocument((DocRef)new IdRef(this.getCurrentDocument().getId()), true);
        return refreshedDocument;
    }

    @Override
    protected boolean requireAsyncDataRetrieval() {
        return this.requireAsyncFetch;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            Document doc = (Document)data.getExtras().get(DOCUMENT);
            this.getLayout().applyChanges(doc);
            this.setResult(-1, new Intent().putExtra(DOCUMENT, (Serializable)doc));
            this.finish();
        }
        if (this.getLayout() != null) {
            this.layout.onActivityResult(requestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void saveDocument() {
        Document doc = this.getCurrentDocument();
        this.getLayout().applyChanges(doc);
        this.setResult(-1, new Intent().putExtra(DOCUMENT, (Serializable)doc));
        this.finish();
    }

    protected void cancelUpdate() {
        Document doc = this.getCurrentDocument();
        this.setResult(0, new Intent().putExtra(DOCUMENT, (Serializable)doc));
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.populateMenu(menu);
        if (Build.VERSION.SDK_INT >= 11) {
            if (LayoutMode.VIEW == this.getMode()) {
                menu.add(0, 1000, 0, (CharSequence)"Switch to Edit").setShowAsAction(1);
            }
            if (LayoutMode.EDIT == this.getMode()) {
                menu.add(0, 1001, 0, (CharSequence)"Switch to View").setShowAsAction(1);
            }
        } else {
            if (LayoutMode.VIEW == this.getMode()) {
                menu.add(0, 1000, 0, (CharSequence)"Switch to Edit");
            }
            if (LayoutMode.EDIT == this.getMode()) {
                menu.add(0, 1001, 0, (CharSequence)"Switch to View");
            }
        }
        return super.onCreateOptionsMenu(menu);
    }

    protected abstract void populateMenu(Menu var1);

    public boolean onOptionsItemSelected(MenuItem item) {
        if (!this.callingIntent.getBooleanExtra(FIRST_CALL, true)) {
            this.finish();
        } else {
            switch (item.getItemId()) {
                case 1000: {
                    Intent editIntent = new Intent(new Intent((Context)this, ((Object)((Object)this)).getClass()).putExtra(DOCUMENT, (Serializable)this.currentDocument).putExtra(MODE, (Serializable)LayoutMode.EDIT).putExtra(FIRST_CALL, false));
                    this.startActivityForResult(editIntent, 0);
                    return true;
                }
                case 1001: {
                    Intent viewIntent = new Intent(new Intent((Context)this, ((Object)((Object)this)).getClass()).putExtra(DOCUMENT, (Serializable)this.getCurrentDocument()).putExtra(MODE, (Serializable)LayoutMode.VIEW).putExtra(FIRST_CALL, false));
                    this.startActivityForResult(viewIntent, 0);
                    return true;
                }
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

