/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.Toast;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.nuxeo.android.activities.BaseDocumentLayoutActivity;
import org.nuxeo.android.activities.BaseListActivity;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public abstract class BaseDocumentsListActivity
extends BaseListActivity {
    protected static final int ACTION_EDIT_DOCUMENT = 0;
    protected static final int ACTION_CREATE_DOCUMENT = 1;
    protected static final int MNU_NEW_LISTITEM = 10;
    protected static final int MNU_VIEW_LIST_EXTERNAL = 1;
    protected static final int MNU_REFRESH = 2;
    protected static final int CTXMNU_VIEW_DOCUMENT = 0;
    protected static final int CTXMNU_EDIT_DOCUMENT = 1;
    protected static final int CTXMNU_VIEW_ATTACHEMENT = 2;
    protected static final int CTXMNU_DELETE = 3;
    protected boolean refresh = false;
    protected LazyUpdatableDocumentsList documentsList;
    protected LinkedHashMap<String, String> allowedDocumentTypes;

    @Override
    protected Object retrieveNuxeoData() throws Exception {
        byte cacheParam = 1;
        if (this.refresh) {
            cacheParam = (byte)(cacheParam | 2);
            this.refresh = false;
        }
        return this.fetchDocumentsList(cacheParam, "");
    }

    protected void forceRefresh() {
        this.refresh = true;
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        super.onNuxeoDataRetrieved(data);
        if (data != null) {
            this.documentsList = (LazyUpdatableDocumentsList)data;
            this.displayDocumentList(this.listView, this.documentsList);
        }
    }

    protected abstract LazyUpdatableDocumentsList fetchDocumentsList(byte var1, String var2) throws Exception;

    @Deprecated
    protected LazyUpdatableDocumentsList fetchDocumentsList(byte cacheParam) throws Exception {
        return this.fetchDocumentsList(cacheParam, "");
    }

    protected abstract void displayDocumentList(ListView var1, LazyDocumentsList var2);

    protected abstract Document initNewDocument(String var1);

    protected abstract Class<? extends BaseDocumentLayoutActivity> getEditActivityClass();

    protected void onDocumentCreate(Document newDocument) {
        this.documentsList.createDocument(newDocument);
    }

    protected void onDocumentUpdate(Document editedDocument) {
        this.documentsList.updateDocument(editedDocument);
    }

    @Override
    protected void doRefresh() {
        if (this.documentsList != null) {
            this.documentsList.refreshAll();
        } else {
            this.runAsyncDataRetrieval();
        }
    }

    protected LazyDocumentsList getDocumentsList() {
        return this.documentsList;
    }

    protected Document getContextMenuDocument(int selectedPosition) {
        return this.documentsList.getDocument(selectedPosition);
    }

    protected void registerDocTypesForCreation(String type, String label) {
        if (this.allowedDocumentTypes == null) {
            this.allowedDocumentTypes = new LinkedHashMap();
        }
        this.allowedDocumentTypes.put(type, label);
    }

    protected LinkedHashMap<String, String> getDocTypesForCreation() {
        if (this.allowedDocumentTypes == null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("File", "File Document");
            map.put("Note", "Note Document");
            map.put("Folder", "Folder Document");
            return map;
        }
        return this.allowedDocumentTypes;
    }

    @Override
    protected void populateMenu(Menu menu) {
        if (Build.VERSION.SDK_INT >= 11) {
            LinkedHashMap<String, String> types = this.getDocTypesForCreation();
            if (types.size() > 0) {
                if (types.size() == 1) {
                    menu.add(0, 10, 0, (CharSequence)"New Item").setShowAsAction(1);
                } else {
                    SubMenu subMenu = menu.addSubMenu(0, 10, 0, (CharSequence)"New item");
                    subMenu.getItem().setShowAsAction(1);
                    int idx = 1;
                    for (String key : types.keySet()) {
                        subMenu.add(0, 10 + idx, idx, (CharSequence)types.get(key));
                        ++idx;
                    }
                }
            }
            menu.add(0, 2, 2, (CharSequence)"Refresh").setShowAsAction(1);
        } else {
            LinkedHashMap<String, String> types = this.getDocTypesForCreation();
            if (types.size() > 0) {
                if (types.size() == 1) {
                    menu.add(0, 10, 0, (CharSequence)"New Item");
                } else {
                    SubMenu subMenu = menu.addSubMenu(0, 10, 0, (CharSequence)"New item");
                    int idx = 1;
                    for (String key : types.keySet()) {
                        subMenu.add(0, 10 + idx, idx, (CharSequence)types.get(key));
                        ++idx;
                    }
                }
            }
            menu.add(0, 2, 2, (CharSequence)"Refresh");
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2: {
                this.doRefresh();
                break;
            }
            case 1: {
                if (this.getDocumentsList() == null) break;
                Uri contentUri = this.getDocumentsList().getContentUri();
                if (contentUri != null) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(contentUri);
                    intent.setFlags(0x4000000);
                    intent.putExtra("windowTitle", "Nuxeo Media Browser");
                    try {
                        this.startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        Toast.makeText((Context)this, (CharSequence)("No Application Available to View this uri " + contentUri.toString()), (int)0).show();
                    }
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"No Uri defined for this list", (int)0).show();
                break;
            }
            default: {
                if (this.getEditActivityClass() == null) {
                    return true;
                }
                if (item.getItemId() > 10) {
                    int idx = item.getItemId() - 10 - 1;
                    if (idx >= this.getDocTypesForCreation().size()) break;
                    String type = new ArrayList<String>(this.getDocTypesForCreation().keySet()).get(idx);
                    this.forceRefresh();
                    Document newDoc = this.initNewDocument(type);
                    if (newDoc == null) break;
                    this.startActivityForResult(new Intent((Context)this, this.getEditActivityClass()).putExtra("document", (Serializable)newDoc).putExtra("mode", (Serializable)LayoutMode.CREATE), 1);
                    break;
                }
                if (item.getItemId() != 10 || this.getDocTypesForCreation().size() != 1) break;
                this.forceRefresh();
                Document newDoc = this.initNewDocument(this.getDocTypesForCreation().keySet().iterator().next());
                if (newDoc == null) break;
                this.startActivityForResult(new Intent((Context)this, this.getEditActivityClass()).putExtra("document", (Serializable)newDoc).putExtra("mode", (Serializable)LayoutMode.CREATE), 1);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            if (data.hasExtra("document")) {
                Document editedDocument = (Document)data.getExtras().get("document");
                this.onDocumentUpdate(editedDocument);
                this.doRefresh();
            }
        } else if (requestCode == 1 && resultCode == -1 && data.hasExtra("document")) {
            Document newDocument = (Document)data.getExtras().get("document");
            this.onDocumentCreate(newDocument);
            this.doRefresh();
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int selectedPosition = info.position;
        Document doc = this.getContextMenuDocument(selectedPosition);
        if (item.getItemId() == 0) {
            if (this.getEditActivityClass() == null) {
                Toast.makeText((Context)this, (CharSequence)"No View activity defined ", (int)0).show();
                return true;
            }
            this.startActivity(new Intent((Context)this, this.getEditActivityClass()).putExtra("document", (Serializable)doc).putExtra("mode", (Serializable)LayoutMode.VIEW));
            return true;
        }
        if (item.getItemId() == 1) {
            if (this.getEditActivityClass() == null) {
                Toast.makeText((Context)this, (CharSequence)"No Edit activity defined ", (int)0).show();
                return true;
            }
            this.startActivityForResult(new Intent((Context)this, this.getEditActivityClass()).putExtra("document", (Serializable)doc).putExtra("mode", (Serializable)LayoutMode.EDIT), 0);
            return true;
        }
        if (item.getItemId() == 2) {
            Uri blobUri = doc.getBlob();
            if (blobUri == null) {
                Toast.makeText((Context)this, (CharSequence)"No Attachement available ", (int)0).show();
            } else {
                this.startViewerFromBlob(blobUri);
            }
            return true;
        }
        if (item.getItemId() == 3) {
            this.deleteDocument(doc);
            this.doRefresh();
            return true;
        }
        return super.onContextItemSelected(item);
    }

    protected void deleteDocument(Document doc) {
        OperationRequest request = this.getNuxeoSession().newRequest("Document.SetLifeCycle");
        request.setInput(doc);
        request.set("value", "delete");
        this.documentsList.updateDocument(doc, request);
    }

    @Override
    protected void onListItemClicked(int listItemPosition) {
        if (this.getEditActivityClass() != null) {
            Document doc = this.documentsList.getDocument(listItemPosition);
            Intent intent = new Intent(new Intent((Context)this, this.getEditActivityClass()).putExtra("document", (Serializable)doc).putExtra("mode", (Serializable)LayoutMode.VIEW).putExtra("first call", true));
            this.startActivityForResult(intent, 0);
        }
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (v.getId() == this.listView.getId()) {
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            Document doc = this.documentsList.getDocument(info.position);
            menu.setHeaderTitle((CharSequence)doc.getTitle());
            this.populateContextMenu(doc, menu);
        }
        super.onCreateContextMenu(menu, v, menuInfo);
    }

    protected void populateContextMenu(Document doc, ContextMenu menu) {
        menu.add(0, 0, 0, (CharSequence)"View");
        menu.add(0, 1, 1, (CharSequence)"Edit");
        menu.add(0, 2, 2, (CharSequence)"View attachment");
        menu.add(0, 3, 2, (CharSequence)"Delete");
    }

    @Override
    public boolean isReady() {
        if (super.isReady()) {
            if (this.documentsList != null) {
                return this.documentsList.getLoadingPagesCount() == 0 && this.documentsList.getLoadedPageCount() > 0;
            }
            return false;
        }
        return false;
    }
}

