/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.os.Build;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import org.nuxeo.android.activities.BaseNuxeoActivity;

public abstract class BaseListActivity
extends BaseNuxeoActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    protected ListView listView;
    protected TextView waitingMessage;
    protected View refreshBtn;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupViews();
        if (this.listView != null) {
            this.registerForContextMenu((View)this.listView);
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.refreshBtn.setVisibility(8);
        } else if (this.refreshBtn != null) {
            this.refreshBtn.setOnClickListener((View.OnClickListener)this);
        }
    }

    protected abstract void setupViews();

    protected void setupViewsOnDataLoading() {
        if (this.waitingMessage != null) {
            this.waitingMessage.setText((CharSequence)"Loading data ...");
            this.waitingMessage.setVisibility(0);
        }
        if (this.refreshBtn != null) {
            this.refreshBtn.setEnabled(false);
        }
    }

    protected void setupViewsOnDataLoaded() {
        if (this.waitingMessage != null) {
            this.waitingMessage.setVisibility(8);
        }
        if (this.refreshBtn != null) {
            this.refreshBtn.setEnabled(true);
        }
    }

    @Override
    protected void onNuxeoDataRetrievalStarted() {
        this.setupViewsOnDataLoading();
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        this.setupViewsOnDataLoaded();
    }

    @Override
    protected void onNuxeoDataRetrieveFailed() {
        this.setupViewsOnDataLoaded();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.populateMenu(menu);
        return super.onCreateOptionsMenu(menu);
    }

    protected abstract void populateMenu(Menu var1);

    public void onClick(View view) {
        if (view == this.refreshBtn) {
            this.doRefresh();
        }
    }

    public void onItemClick(AdapterView<?> list, View container, int position, long id) {
        this.onListItemClicked(position);
    }

    protected abstract void onListItemClicked(int var1);

    protected abstract void doRefresh();

    @Override
    protected boolean requireAsyncDataRetrieval() {
        return true;
    }
}

