/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.activities;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import java.io.File;
import java.io.Serializable;
import org.nuxeo.android.context.NuxeoContext;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.NotAvailableOffline;

public abstract class BaseNuxeoActivity
extends Activity {
    protected boolean loadingInProgress = false;

    protected NuxeoContext getNuxeoContext() {
        return NuxeoContext.get(this.getApplicationContext());
    }

    protected Session getNuxeoSession() {
        return this.getNuxeoContext().getSession();
    }

    protected AndroidAutomationClient getAutomationClient() {
        return this.getNuxeoContext().getNuxeoClient();
    }

    protected abstract boolean requireAsyncDataRetrieval();

    protected void onResume() {
        super.onResume();
        if (this.requireAsyncDataRetrieval()) {
            this.runAsyncDataRetrieval();
        }
    }

    protected void runAsyncDataRetrieval() {
        new NuxeoAsyncTask().execute(null);
    }

    protected Object retrieveNuxeoData() throws Exception {
        return null;
    }

    protected void onNuxeoDataRetrievalStarted() {
    }

    protected void onNuxeoDataRetrieved(Object data) {
    }

    protected void onNuxeoDataRetrieveFailed() {
    }

    protected void startViewerFromBlob(File tmpFile, String mimeTye) {
        Uri path = Uri.fromFile((File)tmpFile);
        this.startViewerFromBlob(path, mimeTye);
    }

    protected void startViewerFromBlob(Uri uri, String mimeTye) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, mimeTye);
        intent.setFlags(0x4000000);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this, (CharSequence)("No Application Available to View " + mimeTye), (int)0).show();
        }
    }

    protected void startViewerFromBlob(Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        intent.setFlags(0x4000000);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this, (CharSequence)("No Application Available to View uri " + uri.toString()), (int)0).show();
        }
    }

    protected void unbindDrawables(View view) {
        if (view.getBackground() != null) {
            view.getBackground().setCallback(null);
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.unbindDrawables(((ViewGroup)view).getChildAt(i));
            }
            try {
                ((ViewGroup)view).removeAllViews();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected <T> T getInitParam(String name, Class<T> type) {
        Object value;
        if (this.getIntent().getExtras() != null && (value = this.getIntent().getExtras().get(name)) != null) {
            return type.cast(value);
        }
        return null;
    }

    public void restart(String paramName, Serializable paramValue) {
        Intent intent = this.getIntent();
        this.overridePendingTransition(0, 0);
        intent.addFlags(65536);
        if (paramName != null) {
            intent.putExtra(paramName, paramValue);
        }
        this.finish();
        this.overridePendingTransition(0, 0);
        this.startActivity(intent);
    }

    public boolean isReady() {
        return !this.loadingInProgress;
    }

    protected class NuxeoAsyncTask
    extends AsyncTask<Void, Integer, Object> {
        protected NuxeoAsyncTask() {
        }

        protected void onPreExecute() {
            BaseNuxeoActivity.this.loadingInProgress = true;
            BaseNuxeoActivity.this.onNuxeoDataRetrievalStarted();
            super.onPreExecute();
        }

        protected Object doInBackground(Void ... arg0) {
            try {
                Object result = BaseNuxeoActivity.this.retrieveNuxeoData();
                return result;
            }
            catch (NotAvailableOffline naoe) {
                BaseNuxeoActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)BaseNuxeoActivity.this, (CharSequence)"This screen can bot be displayed offline", (int)1).show();
                    }
                });
                return null;
            }
            catch (Exception e) {
                Log.e((String)"NuxeoAsyncTask", (String)"Error while executing async Nuxeo task in activity", (Throwable)e);
                try {
                    this.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }

        protected void onPostExecute(Object result) {
            BaseNuxeoActivity.this.loadingInProgress = false;
            if (result != null) {
                BaseNuxeoActivity.this.onNuxeoDataRetrieved(result);
            } else {
                BaseNuxeoActivity.this.onNuxeoDataRetrieveFailed();
            }
        }
    }
}

