/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.adapters;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import org.nuxeo.android.adapters.UUIDMapper;
import org.nuxeo.android.documentprovider.DocumentsListChangeListener;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public abstract class AbstractDocumentListAdapter
extends BaseAdapter {
    protected LayoutInflater inflater;
    protected final LazyDocumentsList docList;
    protected int currentCount = -1;
    protected final UUIDMapper mapper;
    protected Handler handler;
    protected final Integer loadingLayout;
    protected View loadingView;

    public AbstractDocumentListAdapter(Context context, LazyDocumentsList docList) {
        this(context, docList, null);
    }

    public AbstractDocumentListAdapter(Context context, LazyDocumentsList docList, Integer loadingLayout) {
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.docList = docList;
        this.mapper = new UUIDMapper();
        this.loadingLayout = loadingLayout;
        this.registerEventListener();
    }

    protected void registerEventListener() {
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                AbstractDocumentListAdapter.this.currentCount = -1;
                AbstractDocumentListAdapter.this.notifyDataSetChanged();
            }
        };
        this.docList.registerListener(new DocumentsListChangeListener(){

            @Override
            public void notifyContentChanged(int page) {
                AbstractDocumentListAdapter.this.handler.sendEmptyMessage(page);
            }
        });
    }

    protected boolean useLoadingView() {
        return this.loadingLayout != null && !this.docList.isFullyLoaded();
    }

    public int getCount() {
        if (this.currentCount < 0) {
            this.currentCount = this.docList.getCurrentSize();
        }
        if (this.useLoadingView()) {
            return this.currentCount + 1;
        }
        return this.currentCount;
    }

    public int getRealCount() {
        if (this.currentCount < 0) {
            return this.docList.getCurrentSize();
        }
        return this.currentCount;
    }

    public Object getDocumentStatus(Integer position) {
        Document doc = this.getDocument(position);
        if (doc == null) {
            return null;
        }
        return doc.getStatusFlag().toString();
    }

    public Object getDocumentAttribute(Integer position, String attributeName) {
        Document doc = this.getDocument(position);
        if (doc == null) {
            Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("No document found in list for position " + position));
            return null;
        }
        Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("document found in list at position " + position + ", returning attibute " + attributeName));
        return doc.getProperties().get(attributeName);
    }

    public int getFirstPageCount() {
        if (this.docList == null || this.docList.getPageCount() == 0) {
            return 0;
        }
        return this.docList.getFirstPage().size();
    }

    protected Document getDocument(int position) {
        this.docList.setCurrentPosition(position);
        return this.docList.getCurrentDocument();
    }

    public Object getItem(int position) {
        return this.getDocument(position);
    }

    public long getItemId(int position) {
        return this.mapper.getIdentifier(this.getDocument(position));
    }

    protected View getLoadingView(ViewGroup parent) {
        if (this.loadingView == null) {
            this.loadingView = this.inflater.inflate(this.loadingLayout.intValue(), parent, false);
        }
        return this.loadingView;
    }

    public View getView(int position, View recycledView, ViewGroup parent) {
        int realCount = this.getRealCount();
        boolean showLoading = this.useLoadingView();
        if (position >= realCount && showLoading) {
            return this.getLoadingView(parent);
        }
        Document doc = this.getDocument(position);
        if (recycledView == null || recycledView == this.getLoadingView(parent)) {
            recycledView = this.createNewView(position, doc, this.inflater, parent);
        }
        this.bindViewToDocument(position, doc, recycledView);
        return recycledView;
    }

    protected abstract View createNewView(int var1, Document var2, LayoutInflater var3, ViewGroup var4);

    protected abstract void bindViewToDocument(int var1, Document var2, View var3);
}

