/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.adapters;

import java.util.Date;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class DocumentAttributeResolver {
    public static final String ID = "uuid";
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String ICONURI = "iconUri";
    public static final String BLOBURI = "blobUri";
    public static final String PICTUREURI = "pictureUri";
    public static final String STATUS = "status";

    public static Object get(Document doc, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        if (ID.equalsIgnoreCase(attributeName)) {
            return doc.getId();
        }
        if (NAME.equalsIgnoreCase(attributeName)) {
            return doc.getName();
        }
        if (PATH.equalsIgnoreCase(attributeName)) {
            return doc.getPath();
        }
        if (ICONURI.equalsIgnoreCase(attributeName)) {
            return doc.getIcon();
        }
        if (STATUS.equalsIgnoreCase(attributeName)) {
            return doc.getStatusFlag().toString();
        }
        if (attributeName.startsWith(BLOBURI)) {
            String[] parts = attributeName.split(":");
            if (parts.length == 1) {
                return doc.getBlob();
            }
            return doc.getBlob(Integer.parseInt(parts[1]));
        }
        if (attributeName.startsWith(PICTUREURI)) {
            String[] parts = attributeName.split(":");
            if (parts.length == 1) {
                return doc.getPicture(null);
            }
            return doc.getPicture(parts[1]);
        }
        return doc.getProperties().map().get(attributeName);
    }

    public static void put(Document doc, String attributeName, Object value) {
        String strValue;
        if (value != null && value instanceof String && (strValue = (String)value) != null && strValue.contains("'")) {
            value = strValue.replaceAll("'", "\"");
        }
        doc.getProperties().map().put(attributeName, value);
        doc.getDirtyFields().add(attributeName);
    }

    public static String getString(Document doc, String attributeName) {
        Object val = DocumentAttributeResolver.get(doc, attributeName);
        if (val == null || "null".equals(val)) {
            return "";
        }
        return val.toString();
    }

    public static Date getDate(Document doc, String attributeName) {
        return doc.getDate(attributeName);
    }
}

