/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.adapters;

import android.database.AbstractCursor;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.adapters.UUIDMapper;
import org.nuxeo.android.documentprovider.DocumentsListChangeListener;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyDocumentsListImpl;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsListImpl;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;

public class NuxeoDocumentCursor
extends AbstractCursor {
    protected static final String[] FIXED_COLUMNS = new String[]{"_ID", "status", "iconUri"};
    protected String[] columns;
    protected final UUIDMapper mapper;
    protected final LazyDocumentsList docList;
    protected final boolean updatable;

    public NuxeoDocumentCursor(Session session, String nxql, String[] queryParams, String sortOrder, String schemas, int pageSize, UUIDMapper mapper, boolean updatable) {
        this.mapper = mapper != null ? mapper : new UUIDMapper();
        this.updatable = updatable;
        this.docList = updatable ? new LazyUpdatableDocumentsListImpl(session, nxql, queryParams, sortOrder, schemas, pageSize) : new LazyDocumentsListImpl(session, nxql, queryParams, sortOrder, schemas, pageSize);
        this.registerEventListener();
    }

    public NuxeoDocumentCursor(OperationRequest fetchOperation, String pageParameterName, boolean updatable) {
        this.mapper = new UUIDMapper();
        this.updatable = updatable;
        this.docList = updatable ? new LazyUpdatableDocumentsListImpl(fetchOperation, pageParameterName) : new LazyDocumentsListImpl(fetchOperation, pageParameterName);
        this.registerEventListener();
    }

    public NuxeoDocumentCursor(LazyDocumentsList docList) {
        this.mapper = new UUIDMapper();
        this.docList = docList;
        this.updatable = LazyUpdatableDocumentsList.class.isAssignableFrom(docList.getClass());
        this.registerEventListener();
    }

    protected void registerEventListener() {
        this.docList.registerListener(new DocumentsListChangeListener(){

            @Override
            public void notifyContentChanged(int page) {
                NuxeoDocumentCursor.this.onChange(true);
                NuxeoDocumentCursor.this.requery();
            }
        });
    }

    public boolean onMove(int oldPosition, int newPosition) {
        this.docList.setCurrentPosition(newPosition);
        return super.onMove(oldPosition, newPosition);
    }

    public Document getCurrentDocument() {
        return this.docList.getCurrentDocument();
    }

    protected Documents getCurrentPage() {
        return this.docList.getCurrentPage();
    }

    protected Long getCurrentIdentifier() {
        return this.mapper.getIdentifier(this.getCurrentDocument());
    }

    public String[] getColumnNames() {
        if (this.columns == null) {
            ArrayList<String> cols = new ArrayList<String>(((Document)this.getCurrentPage().get(0)).getProperties().getKeys());
            Collections.sort(cols);
            cols.addAll(0, Arrays.asList(FIXED_COLUMNS));
            this.columns = cols.toArray(new String[0]);
        }
        return this.columns;
    }

    public int getCount() {
        return this.docList.getCurrentSize();
    }

    public double getDouble(int column) {
        return this.getCurrentDocument().getDouble(this.columns[column]).floatValue();
    }

    public float getFloat(int column) {
        return this.getCurrentDocument().getDouble(this.columns[column]).floatValue();
    }

    public int getInt(int column) {
        if (column == 0) {
            return this.getCurrentIdentifier().intValue();
        }
        return this.getCurrentDocument().getLong(this.columns[column]).intValue();
    }

    public long getLong(int column) {
        if (column == 0) {
            return this.getCurrentIdentifier();
        }
        return this.getCurrentDocument().getLong(this.columns[column]);
    }

    public short getShort(int column) {
        return this.getCurrentDocument().getLong(this.columns[column]).shortValue();
    }

    public String getString(int column) {
        if (column == 0) {
            return this.getCurrentIdentifier().toString();
        }
        if (column < FIXED_COLUMNS.length) {
            return DocumentAttributeResolver.getString(this.getCurrentDocument(), FIXED_COLUMNS[column]);
        }
        return this.getCurrentDocument().getString(this.columns[column]);
    }

    public boolean isNull(int column) {
        return this.getCurrentDocument().getString(this.columns[column]) == null;
    }

    public void close() {
        super.close();
        for (Documents docs : this.docList.getLoadedPages()) {
            this.mapper.release(docs);
        }
    }

    public Bundle getExtras() {
        Bundle bundle = new Bundle();
        Document doc = this.getCurrentDocument();
        Map<String, Object> data = doc.getProperties().map();
        for (String k : data.keySet()) {
            Object val = data.get(k);
            if (val instanceof String) {
                bundle.putString(k, (String)val);
                continue;
            }
            if (val instanceof Boolean) {
                bundle.putBoolean(k, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof Double) {
                bundle.putDouble(k, ((Double)val).doubleValue());
                continue;
            }
            if (val instanceof Integer) {
                bundle.putInt(k, ((Integer)val).intValue());
                continue;
            }
            if (val instanceof Long) {
                bundle.putLong(k, ((Long)val).longValue());
                continue;
            }
            if (!(val instanceof PropertyList)) continue;
            PropertyList propList = (PropertyList)val;
            String[] stringArray = new String[propList.size()];
            for (int i = 0; i < propList.size(); ++i) {
                stringArray[i] = propList.getString(i);
            }
            bundle.putStringArray(k, stringArray);
        }
        return null;
    }

    public Document getDocument(int index) {
        return this.docList.getDocument(index);
    }

    public Integer getLoadingPagesCount() {
        return this.docList.getLoadingPagesCount();
    }

    public LazyDocumentsList getDocumentsList() {
        return this.docList;
    }

    public LazyUpdatableDocumentsList getUpdatableDocumentsList() {
        if (this.updatable) {
            return (LazyUpdatableDocumentsList)this.docList;
        }
        throw new UnsupportedOperationException("DocumentList is readOnly");
    }
}

