/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.adapters;

import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.adapters.DocumentViewBinder;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class SimpleDocumentViewBinder
implements DocumentViewBinder {
    protected final int layoutId;
    protected final Map<Integer, String> documentAttributesMapping;
    protected static SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd");

    public SimpleDocumentViewBinder(int layoutId, Map<Integer, String> documentAttributesMapping) {
        this.layoutId = layoutId;
        this.documentAttributesMapping = documentAttributesMapping;
    }

    @Override
    public void bindViewToDocument(int position, Document doc, View view) {
        for (Integer idx : this.documentAttributesMapping.keySet()) {
            View widget = view.findViewById(idx.intValue());
            this.bindWidgetToDocumentAttribute(widget, doc, this.documentAttributesMapping.get(idx));
        }
    }

    @Override
    public View createNewView(int position, Document doc, LayoutInflater inflater, ViewGroup parent) {
        return inflater.inflate(this.layoutId, parent, false);
    }

    protected void bindWidgetToDocumentAttribute(View widget, Document doc, String attribute) {
        if (widget instanceof TextView) {
            if (attribute.startsWith("(date)")) {
                Date date = DocumentAttributeResolver.getDate(doc, attribute.substring("(date)".length()));
                if (date != null) {
                    ((TextView)widget).setText((CharSequence)fmt.format(date));
                }
            } else {
                ((TextView)widget).setText((CharSequence)DocumentAttributeResolver.getString(doc, attribute));
            }
        } else if (widget instanceof ImageView) {
            ((ImageView)widget).setImageURI((Uri)DocumentAttributeResolver.get(doc, attribute));
        }
    }
}

