/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.adapters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;

public class UUIDMapper {
    protected ConcurrentHashMap<String, Long> UUID2IDs = new ConcurrentHashMap();
    protected Long lastID = new Long(0L);

    public Long getIdentifier(Document doc) {
        if (doc == null) {
            throw new UnsupportedOperationException("Cannot map a null Document");
        }
        if (doc.getId() == null) {
            throw new UnsupportedOperationException("Cannot map a Document with null UUID");
        }
        return this.getIdentifier(doc.getId());
    }

    private Long generate(String UUID2) {
        this.lastID = this.lastID + 1L;
        return this.lastID;
    }

    public Long getIdentifier(String UUID2) {
        if (!this.UUID2IDs.containsKey(UUID2)) {
            this.UUID2IDs.putIfAbsent(UUID2, this.generate(UUID2));
        }
        return this.UUID2IDs.get(UUID2);
    }

    public String resolveIdentifier(Long id) {
        for (Map.Entry<String, Long> entry : this.UUID2IDs.entrySet()) {
            if (!entry.getValue().equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void bind(Documents docs) {
        for (Document doc : docs) {
            this.getIdentifier(doc);
        }
    }

    public void release(Documents docs) {
        for (Document doc : docs) {
            this.UUID2IDs.remove(doc.getId());
        }
    }
}

