/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.blob;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.android.cache.blob.BlobStore;

public class BlobStoreManager {
    protected final File rootDir;
    protected final Map<String, BlobStore> stores = new HashMap<String, BlobStore>();

    public static File getRootCacheDir(Context context) {
        File dir = context.getExternalCacheDir();
        if (dir == null) {
            Log.w((String)BlobStoreManager.class.getSimpleName(), (String)"No external directory accessible, using main storage");
            dir = context.getFilesDir();
        }
        return dir;
    }

    public BlobStoreManager(Context context) {
        this.rootDir = BlobStoreManager.getRootCacheDir(context);
    }

    public BlobStore getBlobStore(String dir) {
        BlobStore store = this.stores.get(dir);
        if (store == null) {
            File storageDir = this.getTargetDir(dir);
            store = new BlobStore(storageDir);
            this.stores.put(dir, store);
        }
        return store;
    }

    protected File getTargetDir(String dir) {
        File targetDir = new File(this.rootDir, dir);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        return targetDir;
    }

    public Map<String, BlobStore> getStores() {
        return this.stores;
    }
}

