/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.sql;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import org.nuxeo.android.cache.sql.SQLDBAccessor;
import org.nuxeo.android.cache.sql.SQLTableWrapper;

public abstract class AbstractSQLTableWrapper
implements SQLTableWrapper {
    protected SQLDBAccessor accessor;

    @Override
    public abstract String getCreateStatement();

    @Override
    public abstract String getTableName();

    @Override
    public abstract String getKeyColumnName();

    @Override
    public void setDBAccessor(SQLDBAccessor accessor) {
        this.accessor = accessor;
    }

    protected SQLiteDatabase getWritableDatabase() {
        return this.accessor.getWritableDatabase();
    }

    protected SQLiteDatabase getReadableDatabase() {
        return this.accessor.getReadableDatabase();
    }

    protected void execTransactionalSQL(SQLiteDatabase db, String sql) {
        this.execTransactionalSQL(db, sql, null);
    }

    protected void execTransactionalSQL(SQLiteDatabase db, String sql, Object[] args) {
        db.beginTransaction();
        if (args == null) {
            db.execSQL(sql);
        } else {
            db.execSQL(sql, args);
        }
        db.setTransactionSuccessful();
        db.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCount() {
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select count(*) from " + this.getTableName();
        SQLiteStatement statement = null;
        try {
            statement = db.compileStatement(sql);
            long l = statement.simpleQueryForLong();
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Override
    public void clearTable() {
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "delete  from " + this.getTableName();
        this.execTransactionalSQL(db, sql);
    }

    @Override
    public void deleteEntry(String key) {
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "delete  from " + this.getTableName() + " where " + this.getKeyColumnName() + "='" + key + "'";
        this.execTransactionalSQL(db, sql);
    }

    protected void dump() {
        int i;
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select * from " + this.getTableName();
        Cursor cursor = db.rawQuery(sql, null);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < cursor.getColumnCount(); ++i) {
            sb.append(" | ");
            sb.append(cursor.getColumnName(i));
        }
        Log.i((String)this.getClass().getSimpleName(), (String)sb.toString());
        if (cursor.getCount() > 0 && cursor.moveToFirst()) {
            do {
                sb = new StringBuffer();
                for (i = 0; i < cursor.getColumnCount(); ++i) {
                    sb.append(" | ");
                    sb.append(cursor.getString(i));
                }
                Log.i((String)this.getClass().getSimpleName(), (String)sb.toString());
            } while (cursor.moveToNext());
        }
        cursor.close();
    }
}

