/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.sql;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import org.json.JSONObject;
import org.nuxeo.android.cache.sql.AbstractSQLTableWrapper;
import org.nuxeo.android.cache.sql.OperationPersisterHelper;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyDocumentsListImpl;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsListImpl;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;

public class DocumentProviderTableWrapper
extends AbstractSQLTableWrapper {
    public static final String TBLNAME = "NuxeoDocumentProviders";
    protected static final String KEY_COLUMN = "NAME";
    protected static final String OPID_COLUMN = "OPERATIONID";
    protected static final String PARAMS_COLUMN = "PARAMS";
    protected static final String HEADERS_COLUMN = "HEADERS";
    protected static final String CTX_COLUMN = "CTX";
    protected static final String INPUT_TYPE_COLUMN = "INPUT_TYPE";
    protected static final String INPUT_REF_COLUMN = "INPUT_REF";
    protected static final String INPUT_BINARY_COLUMN = "INPUT_BIN";
    protected static final String PAGE_PARAM_COLUMN = "PAGEPARAM";
    protected static final String READ_ONLY_COLUMN = "READONLY";
    protected static final String CREATE_STATEMENT = "CREATE TABLE NuxeoDocumentProviders (NAME TEXT, OPERATIONID TEXT, PARAMS TEXT, HEADERS TEXT, CTX TEXT, PAGEPARAM TEXT, READONLY TEXT, INPUT_TYPE TEXT, INPUT_REF TEXT, INPUT_BIN TEXT);";

    @Override
    public String getCreateStatement() {
        return CREATE_STATEMENT;
    }

    @Override
    public String getKeyColumnName() {
        return KEY_COLUMN;
    }

    @Override
    public String getTableName() {
        return TBLNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyDocumentsList getStoredProvider(Session session, String name) {
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select * from " + this.getTableName() + " where " + KEY_COLUMN + "='" + name + "'";
        Cursor cursor = db.rawQuery(sql, null);
        try {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                String operationKey = cursor.getString(cursor.getColumnIndex(KEY_COLUMN));
                String operationId = cursor.getString(cursor.getColumnIndex(OPID_COLUMN));
                String jsonParams = cursor.getString(cursor.getColumnIndex(PARAMS_COLUMN));
                String jsonHeaders = cursor.getString(cursor.getColumnIndex(HEADERS_COLUMN));
                String jsonCtx = cursor.getString(cursor.getColumnIndex(CTX_COLUMN));
                String inputType = cursor.getString(cursor.getColumnIndex(INPUT_TYPE_COLUMN));
                String inputRef = cursor.getString(cursor.getColumnIndex(INPUT_REF_COLUMN));
                Boolean inputBin = false;
                if (inputType != null) {
                    inputBin = new Boolean(cursor.getString(cursor.getColumnIndex(INPUT_BINARY_COLUMN)));
                }
                OperationRequest request = OperationPersisterHelper.rebuildOperation(session, operationId, jsonParams, jsonHeaders, jsonCtx, inputType, inputRef, inputBin);
                Boolean readOnly = new Boolean(cursor.getString(cursor.getColumnIndex(READ_ONLY_COLUMN)));
                String pageParam = cursor.getString(cursor.getColumnIndex(PAGE_PARAM_COLUMN));
                LazyDocumentsListImpl result = null;
                result = readOnly != false ? new LazyDocumentsListImpl(request, pageParam) : new LazyUpdatableDocumentsListImpl(request, pageParam);
                result.setName(name);
                LazyDocumentsListImpl lazyDocumentsListImpl = result;
                return lazyDocumentsListImpl;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public void storeProvider(String name, LazyDocumentsList docList) {
        OperationRequest request = docList.getFetchOperation();
        String pageParam = docList.getPageParameterName();
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "INSERT INTO " + this.getTableName() + " (" + KEY_COLUMN + "," + OPID_COLUMN + "," + PARAMS_COLUMN + "," + HEADERS_COLUMN + "," + CTX_COLUMN + "," + PAGE_PARAM_COLUMN + "," + READ_ONLY_COLUMN;
        String operationId = request.getDocumentation().getId();
        String jsonParams = new JSONObject(request.getParameters()).toString();
        String jsonHeaders = new JSONObject(request.getHeaders()).toString();
        String jsonCtx = new JSONObject(request.getContextParameters()).toString();
        String sqlValues = " VALUES ('" + name + "'," + "'" + operationId + "'," + "'" + jsonParams + "'," + "'" + jsonHeaders + "'," + "'" + jsonCtx + "'," + "'" + pageParam + "'," + "'" + new Boolean(docList.isReadOnly()).toString() + "'";
        if (request.getInput() != null) {
            String inputType = request.getInput().getInputType();
            String inputRef = request.getInput().getInputRef();
            String inputBin = new Boolean(request.getInput().isBinary()).toString();
            sql = sql + "," + INPUT_TYPE_COLUMN + "," + INPUT_REF_COLUMN + "," + INPUT_BINARY_COLUMN;
            sqlValues = sqlValues + ",'" + inputType + "','" + inputRef + "','" + inputBin + "'";
        }
        String insertQuery = sql + " ) " + sqlValues + ");";
        this.execTransactionalSQL(db, insertQuery);
    }
}

