/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.sql;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.android.cache.sql.AbstractSQLTableWrapper;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheEntry;

public class ResponseCacheTableWrapper
extends AbstractSQLTableWrapper {
    public static final String TBLNAME = "NuxeoCacheEntries";
    protected static final String KEY_COLUMN = "KEY";
    protected static final String CTYPE_COLUMN = "CTYPE";
    protected static final String CDISP_COLUMN = "CDISP";
    protected static final String RTYPE_COLUMN = "RTYPE";
    protected static final String RENTITY_COLUMN = "RENTITY";
    protected static final String CREATE_STATEMENT = "CREATE TABLE NuxeoCacheEntries (KEY TEXT, CTYPE TEXT, CDISP TEXT, RTYPE TEXT, RENTITY TEXT);";

    @Override
    public String getCreateStatement() {
        return CREATE_STATEMENT;
    }

    @Override
    public String getTableName() {
        return TBLNAME;
    }

    @Override
    public String getKeyColumnName() {
        return KEY_COLUMN;
    }

    protected String escape(String content) {
        return content.replaceAll("'", "'");
    }

    protected void addEntry(SQLiteDatabase db, String key, ResponseCacheEntry entry) {
        String sql = "INSERT INTO NuxeoCacheEntries (KEY,CTYPE,CDISP,RTYPE,RENTITY) VALUES ( ?, ?, ?, ?, ?)";
        Object[] args = new String[]{key, entry.getReponseContentType(), entry.getResponseContentDisposition(), entry.getRequestMethod() + "", entry.getRequestEntity()};
        this.execTransactionalSQL(db, sql, args);
    }

    protected void updateEntry(SQLiteDatabase db, String key, ResponseCacheEntry entry) {
        String sql = "UPDATE NuxeoCacheEntries set CTYPE = '" + entry.getReponseContentType() + "'," + CDISP_COLUMN + " = " + "'" + entry.getResponseContentDisposition() + "'," + RTYPE_COLUMN + " = " + "'" + entry.getRequestMethod() + "'," + RENTITY_COLUMN + " = " + "'" + entry.getRequestEntity() + "'" + " where " + KEY_COLUMN + " = " + "'" + key + "';";
        this.execTransactionalSQL(db, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCacheEntry(String key, ResponseCacheEntry entry) {
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "select count(*) from NuxeoCacheEntries where KEY= '" + key + "'";
        SQLiteStatement statement = db.compileStatement(sql);
        try {
            long nb = statement.simpleQueryForLong();
            if (nb > 0L) {
                this.updateEntry(db, key, entry);
            } else {
                this.addEntry(db, key, entry);
            }
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseCacheEntry getEntry(String key) {
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select * from NuxeoCacheEntries where KEY= '" + key + "'";
        Cursor cursor = db.rawQuery(sql, null);
        try {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                String cType = cursor.getString(cursor.getColumnIndex(CTYPE_COLUMN));
                String cDisp = cursor.getString(cursor.getColumnIndex(CDISP_COLUMN));
                String rType = cursor.getString(cursor.getColumnIndex(RTYPE_COLUMN));
                String entity = cursor.getString(cursor.getColumnIndex(RENTITY_COLUMN));
                ResponseCacheEntry cEntry = new ResponseCacheEntry(cType, cDisp, null, null);
                cEntry.setRequestMethod(Integer.parseInt(rType));
                cEntry.setRequestEntity(entity);
                ResponseCacheEntry responseCacheEntry = cEntry;
                return responseCacheEntry;
            }
            ResponseCacheEntry responseCacheEntry = null;
            return responseCacheEntry;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select KEY from NuxeoCacheEntries";
        Cursor cursor = db.rawQuery(sql, null);
        try {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                do {
                    keys.add(cursor.getString(cursor.getColumnIndex(KEY_COLUMN)));
                } while (cursor.moveToNext());
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

