/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.sql;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.android.cache.sql.SQLDBAccessor;
import org.nuxeo.android.cache.sql.SQLTableWrapper;

public class SQLStateManager
extends SQLiteOpenHelper {
    protected static final int VERSION = 1;
    protected static final String DBNAME = "NuxeoCaches";
    protected Map<String, SQLTableWrapper> tableWrappers = new HashMap<String, SQLTableWrapper>();

    public SQLStateManager(Context context) {
        super(context, DBNAME, null, 1);
    }

    public void registerWrapper(SQLTableWrapper wrapper) {
        this.tableWrappers.put(wrapper.getTableName(), wrapper);
        final SQLStateManager sm = this;
        wrapper.setDBAccessor(new SQLDBAccessor(){

            @Override
            public SQLiteDatabase getWritableDatabase() {
                return sm.getWritableDatabase();
            }

            @Override
            public SQLiteDatabase getReadableDatabase() {
                return sm.getReadableDatabase();
            }
        });
    }

    public void onCreate(SQLiteDatabase db) {
        for (SQLTableWrapper wrapper : this.tableWrappers.values()) {
            db.execSQL(wrapper.getCreateStatement());
        }
    }

    public void onUpgrade(SQLiteDatabase db, int arg1, int arg2) {
    }

    public SQLTableWrapper getTableWrapper(String name) {
        return this.tableWrappers.get(name);
    }
}

