/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.cache.sql;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.android.cache.sql.AbstractSQLTableWrapper;
import org.nuxeo.ecm.automation.client.cache.DocumentDeltaSet;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;
import org.nuxeo.ecm.automation.client.jaxrs.util.JSONExporter;

public class TransientStateTableWrapper
extends AbstractSQLTableWrapper {
    public static final String TBLNAME = "NuxeoTransientState";
    protected static final String KEY_COLUMN = "UID";
    protected static final String PATH_COLUMN = "PATH";
    protected static final String OPTYPE_COLUMN = "OPTYPE";
    protected static final String DOCTYPE_COLUMN = "DOCTYPE";
    protected static final String PROPS_COLUMN = "PROPS";
    protected static final String LISTNAME_COLUMN = "LISTNAME";
    protected static final String REQUESTID_COLUMN = "REQUESTID";
    protected static final String CONFLICT_COLUMN = "CONFLICT";
    protected static final String CREATE_STATEMENT = "CREATE TABLE NuxeoTransientState (UID TEXT, PATH TEXT, OPTYPE TEXT, DOCTYPE TEXT, LISTNAME TEXT, REQUESTID TEXT, CONFLICT TEXT, PROPS TEXT); ";

    @Override
    public String getCreateStatement() {
        return CREATE_STATEMENT;
    }

    @Override
    public String getKeyColumnName() {
        return KEY_COLUMN;
    }

    @Override
    public String getTableName() {
        return TBLNAME;
    }

    public void storeDeltaSet(DocumentDeltaSet deltaSet) {
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "INSERT INTO " + this.getTableName() + " (" + KEY_COLUMN + "," + PATH_COLUMN + "," + OPTYPE_COLUMN + "," + DOCTYPE_COLUMN + "," + PROPS_COLUMN + "," + REQUESTID_COLUMN + "," + LISTNAME_COLUMN + ") ";
        sql = sql + " VALUES (" + "'" + deltaSet.getId() + "'," + "'" + deltaSet.getPath() + "'," + "'" + deltaSet.getOperationType().toString() + "'," + "'" + deltaSet.getDocType() + "'," + "'" + JSONExporter.toJSON(deltaSet.getDirtyProps()) + "'," + "'" + deltaSet.getRequestId() + "'," + "'" + deltaSet.getListName() + "');";
        this.execTransactionalSQL(db, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentDeltaSet> getDeltaSets(List<String> ids, String targetListName) {
        SQLiteDatabase db = this.getReadableDatabase();
        String sql = "select * from " + this.getTableName() + " where " + this.getKeyColumnName() + " IN (";
        for (String id : ids) {
            sql = sql + "'" + id + "', ";
        }
        sql = sql + "'') ";
        if (targetListName != null) {
            sql = sql + " or " + LISTNAME_COLUMN + "='" + targetListName + "'";
        }
        sql = sql + ";";
        Cursor cursor = db.rawQuery(sql, null);
        ArrayList<DocumentDeltaSet> result = new ArrayList<DocumentDeltaSet>();
        try {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                do {
                    String uuid = cursor.getString(cursor.getColumnIndex(KEY_COLUMN));
                    String path = cursor.getString(cursor.getColumnIndex(PATH_COLUMN));
                    OperationType opType = OperationType.fromString(cursor.getString(cursor.getColumnIndex(OPTYPE_COLUMN)));
                    String docType = cursor.getString(cursor.getColumnIndex(DOCTYPE_COLUMN));
                    PropertyMap props = null;
                    String jsonProps = cursor.getString(cursor.getColumnIndex(PROPS_COLUMN));
                    if (jsonProps != null) {
                        props = JSONExporter.getFromJSONString(jsonProps);
                    }
                    String listName = cursor.getString(cursor.getColumnIndex(LISTNAME_COLUMN));
                    String requestId = cursor.getString(cursor.getColumnIndex(REQUESTID_COLUMN));
                    String conflict = cursor.getString(cursor.getColumnIndex(CONFLICT_COLUMN));
                    DocumentDeltaSet delta = new DocumentDeltaSet(opType, uuid, path, docType, props, requestId, listName);
                    if (conflict != null) {
                        delta.setConflict(Boolean.parseBoolean(conflict));
                    }
                    result.add(delta);
                } while (cursor.moveToNext());
            }
            ArrayList<DocumentDeltaSet> arrayList = result;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void deleteEntryByRequestId(String key) {
        SQLiteDatabase db = this.getWritableDatabase();
        String sql = "delete  from " + this.getTableName() + " where " + REQUESTID_COLUMN + "='" + key + "'";
        this.execTransactionalSQL(db, sql);
    }

    public void updateConflictMarker(String uid, boolean conflict) {
        SQLiteDatabase db = this.getWritableDatabase();
        String strConflict = new Boolean(conflict).toString();
        String sql = "update  " + this.getTableName() + " set " + CONFLICT_COLUMN + "= '" + strConflict + "'  where " + KEY_COLUMN + "='" + uid + "'";
        Log.i((String)this.getClass().getSimpleName(), (String)sql);
        this.execTransactionalSQL(db, sql);
    }
}

