/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.config;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class NuxeoServerConfig
implements SharedPreferences.OnSharedPreferenceChangeListener {
    public static final String PREF_SERVER_URL = "nuxeo.serverUrl";
    public static final String PREF_SERVER_LOGIN = "nuxeo.login";
    public static final String PREF_SERVER_PASSWORD = "nuxeo.password";
    public static final String PREF_SERVER_TOKEN = "nuxeo.auth.token";
    private static final String PREF_CACHEKEY = "nuxeo.cache.key";
    private static final String TAG = "NuxeoServerConfig";
    protected Context androidContext;
    protected SharedPreferences sharedPrefs;
    protected String serverBaseUrl = "http://10.0.2.2:8080/nuxeo/";
    protected String login = "Administrator";
    protected String password = "Administrator";
    protected String token = "";

    public NuxeoServerConfig(Context androidContext) {
        this.androidContext = androidContext;
        this.setSharedPrefs(PreferenceManager.getDefaultSharedPreferences((Context)androidContext));
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        if (!serverBaseUrl.endsWith("/")) {
            serverBaseUrl = serverBaseUrl + "/";
        }
        this.serverBaseUrl = serverBaseUrl;
    }

    public void setServerBaseUrl(Uri serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl.toString();
    }

    public String getAutomationUrl() {
        return this.serverBaseUrl + "site/automation";
    }

    public String getHost() {
        URI uri;
        String url = this.getServerBaseUrl();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return uri.getHost();
    }

    public int getHostIP() {
        return this.getIPasInt(this.getHost());
    }

    protected int getIPasInt(String hostname) {
        InetAddress inetAddress;
        if (hostname == null) {
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return -1;
        }
        byte[] addrBytes = inetAddress.getAddress();
        int addr = (addrBytes[3] & 0xFF) << 24 | (addrBytes[2] & 0xFF) << 16 | (addrBytes[1] & 0xFF) << 8 | addrBytes[0] & 0xFF;
        return addr;
    }

    public SharedPreferences getSharedPrefs() {
        return this.sharedPrefs;
    }

    public void setSharedPrefs(SharedPreferences sharedPrefs) {
        this.sharedPrefs = sharedPrefs;
        sharedPrefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.initFromPrefs();
    }

    public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
        if (PREF_SERVER_LOGIN.equals(key) || PREF_SERVER_PASSWORD.equals(key) || PREF_SERVER_URL.equals(key) || PREF_SERVER_TOKEN.equals(key)) {
            this.initFromPrefs();
        }
    }

    protected void initFromPrefs() {
        this.serverBaseUrl = this.sharedPrefs.getString(PREF_SERVER_URL, this.serverBaseUrl);
        this.login = this.sharedPrefs.getString(PREF_SERVER_LOGIN, this.login);
        this.password = this.sharedPrefs.getString(PREF_SERVER_PASSWORD, this.password);
        this.token = this.sharedPrefs.getString(PREF_SERVER_TOKEN, this.token);
        Log.d((String)TAG, (String)("init url=" + this.serverBaseUrl));
        this.androidContext.sendBroadcast(new Intent("NuxeoSettingsChanged"));
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCacheKey() {
        String key = this.sharedPrefs.getString(PREF_CACHEKEY, PREF_SERVER_PASSWORD);
        return this.sharedPrefs.getString(key, this.password);
    }

    public void setCacheKey(String sharedPrefsKey) {
        SharedPreferences.Editor edit = this.sharedPrefs.edit();
        edit.putString(PREF_CACHEKEY, sharedPrefsKey);
        edit.commit();
    }
}

