/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.contentprovider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.nuxeo.android.adapters.NuxeoDocumentCursor;
import org.nuxeo.android.adapters.UUIDMapper;
import org.nuxeo.android.cache.blob.BlobWithProperties;
import org.nuxeo.android.contentprovider.BitmapSampler;
import org.nuxeo.android.contentprovider.NuxeoContentProviderConfig;
import org.nuxeo.android.context.NuxeoContext;
import org.nuxeo.android.documentprovider.DocumentProvider;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.download.FileDownloader;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.FileBlob;

public abstract class AbstractNuxeoReadOnlyContentProvider
extends ContentProvider {
    protected UUIDMapper mapper;
    protected UriMatcher uriMatcher;
    public static final String ALL_DOCUMENTS = "documents";
    public static final String ICONS = "icons";
    public static final String BLOBS = "blobs";
    public static final String UPLOAD = "uploads";
    public static final String PICTURES = "pictures";
    protected static final int ALL_DOCUMENTS_PROVIDER = 0;
    protected static final int ANY_DOCUMENT_PROVIDER = 1;
    protected static final int ICONS_PROVIDER = 2;
    protected static final int BLOBS_PROVIDER = 3;
    protected static final int DOCUMENTS_PROVIDER = 4;
    protected static final int DOCUMENT_PROVIDER = 5;
    protected static final int PICTURES_PROVIDER = 6;
    protected static final int UPLOAD_PROVIDER = 7;

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void attachInfo(Context context, ProviderInfo info) {
        NuxeoContentProviderConfig.init(info);
        this.initMapper();
        super.attachInfo(context, info);
    }

    public boolean onCreate() {
        this.mapper = new UUIDMapper();
        return true;
    }

    protected void initMapper() {
        String authority = NuxeoContentProviderConfig.getAuthority();
        this.uriMatcher = new UriMatcher(-1);
        this.uriMatcher.addURI(authority, ALL_DOCUMENTS, 0);
        this.uriMatcher.addURI(authority, "documents/*", 1);
        this.uriMatcher.addURI(authority, "icons/*", 2);
        this.uriMatcher.addURI(authority, "icons/*/*", 2);
        this.uriMatcher.addURI(authority, "icons/*/*/*", 2);
        this.uriMatcher.addURI(authority, "icons/*/*/*/*", 2);
        this.uriMatcher.addURI(authority, "blobs/*", 3);
        this.uriMatcher.addURI(authority, "blobs/*/#", 3);
        this.uriMatcher.addURI(authority, "blobs/*/*", 3);
        this.uriMatcher.addURI(authority, "blobs/*/*/*", 3);
        this.uriMatcher.addURI(authority, "blobs/*/*/*/*", 3);
        this.uriMatcher.addURI(authority, "pictures/*/*", 6);
        this.uriMatcher.addURI(authority, "pictures/*", 6);
        this.uriMatcher.addURI(authority, "*", 4);
        this.uriMatcher.addURI(authority, "*/*", 5);
        this.uriMatcher.addURI(authority, "uploads/*", 7);
    }

    protected UriMatcher getMatcher() {
        if (this.uriMatcher == null) {
            this.initMapper();
        }
        return this.uriMatcher;
    }

    protected LazyDocumentsList resolveDocumentProvider(Uri uri) {
        DocumentProvider providerService = ((AndroidAutomationClient)this.getSession().getClient()).getDocumentProvider();
        List segments = uri.getPathSegments();
        if (segments.size() < 1) {
            return null;
        }
        String providerName = (String)segments.get(0);
        LazyDocumentsList docList = providerService.getReadOnlyDocumentsList(providerName, this.getSession());
        return docList;
    }

    public Cursor query(Uri uri, String[] columns, String selection, String[] selectionArgs, String sortOrder) {
        int match = this.getMatcher().match(uri);
        switch (match) {
            case 0: {
                String nxql = this.buildNXQLQuery(selection, selectionArgs, sortOrder);
                return this.buildCursor(nxql, selection, selectionArgs, sortOrder);
            }
            case 4: {
                LazyDocumentsList docList = this.resolveDocumentProvider(uri);
                if (docList == null) break;
                return new NuxeoDocumentCursor(docList);
            }
        }
        return null;
    }

    protected Session getSession() {
        return NuxeoContext.get(this.getContext()).getSession();
    }

    protected AndroidAutomationClient getClient() {
        return (AndroidAutomationClient)this.getSession().getClient();
    }

    protected NuxeoDocumentCursor buildCursor(String nxql, String selection, String[] selectionArgs, String sortOrder) {
        return new NuxeoDocumentCursor(this.getSession(), nxql, selectionArgs, sortOrder, this.getSchemas(), this.getDefaultPageSize(), this.mapper, false);
    }

    protected abstract int getDefaultPageSize();

    protected String getSchemas() {
        return "common,dublincore";
    }

    protected String buildNXQLQuery(String selection, String[] selectionArgs, String sortOrder) {
        String nxql = "select * from Document ";
        if (selection != null) {
            nxql = nxql + " where " + selection;
        }
        if (sortOrder != null && !sortOrder.equals("")) {
            nxql = nxql + " order by " + sortOrder;
        }
        return nxql;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getType(Uri uri) {
        String mimeType = null;
        int match = this.getMatcher().match(uri);
        switch (match) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                FileBlob blob = this.resolveBlob(uri);
                if (blob == null) break;
                mimeType = blob.getMimeType();
                break;
            }
            case 4: {
                LazyDocumentsList docList = this.resolveDocumentProvider(uri);
                if (docList == null) break;
                String mt = docList.getExposedMimeType();
                if (mt == null) {
                    mt = "org.nuxeo.document";
                }
                mimeType = "vnd.android.cursor.dir/" + mt;
                break;
            }
            case 5: {
                LazyDocumentsList docList2 = this.resolveDocumentProvider(uri);
                if (docList2 == null) break;
                String mt = docList2.getExposedMimeType();
                if (mt == null) {
                    mt = "org.nuxeo.document";
                }
                mimeType = "vnd.android.cursor.item/" + mt;
            }
        }
        Log.i((String)"NuxeoContentProvider", (String)("==> " + mimeType));
        return mimeType;
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        return super.openAssetFile(uri, mode);
    }

    protected FileBlob resolveBlob(Uri uri) {
        String resourceType = (String)uri.getPathSegments().get(0);
        FileDownloader downloader = this.getClient().getFileDownloader();
        if (resourceType.equals(ICONS)) {
            String subPath = uri.getEncodedPath().toString();
            FileBlob iconFile = downloader.getIcon(subPath = subPath.replaceFirst("/icons", ""));
            if (iconFile != null) {
                return iconFile;
            }
        } else if (resourceType.equals(UPLOAD)) {
            BlobWithProperties tmpBlob = this.getClient().getFileUploader().getBlob(uri.getLastPathSegment());
            if (tmpBlob.getMimeType() != null && tmpBlob.getMimeType().startsWith("image")) {
                return BitmapSampler.sampleBitmapFile(this.getContext(), tmpBlob);
            }
        } else if (resourceType.equals(BLOBS)) {
            String uid = (String)uri.getPathSegments().get(1);
            FileBlob blob = null;
            String suffix = null;
            Integer idx = null;
            if (uri.getPathSegments().size() > 2) {
                suffix = (String)uri.getPathSegments().get(2);
                try {
                    idx = Integer.parseInt(suffix);
                    blob = downloader.getBlob(uid, idx);
                }
                catch (NumberFormatException e) {
                    idx = uri.toString().indexOf(uid);
                    String subPath = uri.toString().substring(idx + uid.length() + 1);
                    blob = downloader.getBlob(uid, subPath);
                }
            } else {
                blob = downloader.getBlob(uid);
            }
            if (blob != null) {
                return blob;
            }
        } else if (resourceType.equals(PICTURES)) {
            String uid = (String)uri.getPathSegments().get(1);
            FileBlob blob = null;
            String format = "Small";
            Object idx = null;
            if (uri.getPathSegments().size() > 2) {
                format = (String)uri.getPathSegments().get(2);
            }
            if ((blob = downloader.getPicture(uid, format)) != null) {
                return blob;
            }
        }
        return null;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        FileBlob blob = this.resolveBlob(uri);
        if (blob != null) {
            return ParcelFileDescriptor.open((File)blob.getFile(), (int)0x10000000);
        }
        return null;
    }
}

