/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.contentprovider;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.ecm.automation.client.jaxrs.model.FileBlob;

public class BitmapSampler {
    public static final int REQUIRED_SIZE = 100;

    public static FileBlob sampleBitmapFile(Context ctx, FileBlob blob) {
        Bitmap sampled = BitmapSampler.decodeFile(blob.getFile());
        try {
            File dir = BlobStoreManager.getRootCacheDir(ctx);
            String filename = "sampled-" + blob.getFileName() + ".jpg";
            File sampledFile = new File(dir, filename);
            if (!sampledFile.exists()) {
                FileOutputStream out = new FileOutputStream(sampledFile);
                sampled.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
            }
            return new FileBlob(sampledFile, sampledFile.getName(), "image/jpeg");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Bitmap decodeFile(File f) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o);
            int width_tmp = o.outWidth;
            int height_tmp = o.outHeight;
            int scale = 1;
            while (width_tmp / 2 >= 100 && height_tmp / 2 >= 100) {
                width_tmp /= 2;
                height_tmp /= 2;
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }
}

