/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.context;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.util.Log;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.android.config.NuxeoServerConfig;
import org.nuxeo.android.context.NuxeoContextProvider;
import org.nuxeo.android.network.NetworkStatusBroadCastReceiver;
import org.nuxeo.android.network.NuxeoNetworkStatus;
import org.nuxeo.android.repository.DocumentManager;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Session;

public class NuxeoContext
extends BroadcastReceiver {
    private static final String TAG = "NuxeoContext";
    protected static NuxeoContext instance = null;
    protected NuxeoServerConfig serverConfig;
    protected NuxeoNetworkStatus networkStatus;
    protected AndroidAutomationClient nuxeoClient;
    protected final SQLStateManager sqlStateManager;
    protected final Context androidContext;
    protected final BlobStoreManager blobStore;
    private boolean shuttingDown;
    private NetworkStatusBroadCastReceiver networkStatusBroadCastReceiver;

    public static NuxeoContext get(Context nxContextProvider) {
        if (nxContextProvider instanceof NuxeoContextProvider) {
            NuxeoContextProvider nxApp = (NuxeoContextProvider)nxContextProvider;
            return nxApp.getNuxeoContext();
        }
        throw new UnsupportedOperationException("Your application Context should implement NuxeoContextProvider !");
    }

    public NuxeoContext(Context androidContext) {
        this(androidContext, new NuxeoServerConfig(androidContext));
    }

    public NuxeoContext(Context androidContext, NuxeoServerConfig nxConfig) {
        this.androidContext = androidContext;
        this.sqlStateManager = new SQLStateManager(androidContext);
        this.blobStore = new BlobStoreManager(androidContext);
        this.serverConfig = nxConfig;
        this.networkStatus = new NuxeoNetworkStatus(androidContext, this.serverConfig, (ConnectivityManager)androidContext.getSystemService("connectivity"));
        this.networkStatusBroadCastReceiver = new NetworkStatusBroadCastReceiver(this.networkStatus);
        androidContext.registerReceiver((BroadcastReceiver)this.networkStatusBroadCastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("NuxeoSettingsChanged");
        filter.addAction("NuxeoServerConnectivityChanged");
        androidContext.registerReceiver((BroadcastReceiver)this, filter);
        this.getNuxeoClient();
    }

    public NuxeoServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public NuxeoNetworkStatus getNetworkStatus() {
        return this.networkStatus;
    }

    public synchronized Session getSession() {
        return this.getNuxeoClient().getSession();
    }

    public DocumentManager getDocumentManager() {
        return this.getSession().getAdapter(DocumentManager.class);
    }

    public synchronized void onConfigChanged() {
        Log.d((String)TAG, (String)"onConfigChanged");
        if (this.nuxeoClient != null) {
            Log.d((String)TAG, (String)("shutdown " + this.nuxeoClient));
            this.shuttingDown = true;
            this.nuxeoClient.dropCurrentSession();
            this.nuxeoClient.shutdown();
            this.nuxeoClient = null;
            ((Object)((Object)this)).notify();
        }
    }

    protected void onConnectivityChanged() {
    }

    public void onReceive(Context ctx, Intent intent) {
        if (intent.getAction().equals("NuxeoSettingsChanged")) {
            this.onConfigChanged();
        } else if (intent.getAction().equals("NuxeoServerConnectivityChanged")) {
            this.onConnectivityChanged();
        }
    }

    public synchronized AndroidAutomationClient getNuxeoClient() {
        while (this.nuxeoClient != null && this.shuttingDown) {
            try {
                ((Object)((Object)this)).wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.nuxeoClient == null || this.nuxeoClient.isShutdown()) {
            this.shuttingDown = false;
            this.nuxeoClient = new AndroidAutomationClient(this.serverConfig.getAutomationUrl(), this.androidContext, this.sqlStateManager, this.blobStore, this.networkStatus, this.serverConfig);
            Log.i((String)TAG, (String)("new Nuxeo client " + this.nuxeoClient));
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Call stack: ", (Throwable)new Exception());
            }
        }
        return this.nuxeoClient;
    }

    public void shutdown() {
        Log.d((String)TAG, (String)"context shutdown", (Throwable)new Exception());
        try {
            this.onConfigChanged();
            this.androidContext.unregisterReceiver((BroadcastReceiver)this);
            this.androidContext.unregisterReceiver((BroadcastReceiver)this.networkStatus);
            this.androidContext.unregisterReceiver((BroadcastReceiver)this.networkStatusBroadCastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

