/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.documentprovider;

import android.os.Bundle;
import android.util.Log;
import org.nuxeo.android.documentprovider.LazyDocumentsListImpl;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsListImpl;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.broadcast.EventLifeCycle;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.cache.TransientStateManager;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.ConflictException;
import org.nuxeo.ecm.automation.client.jaxrs.Dependency;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;

public abstract class AbstractLazyUpdatebleDocumentsList
extends LazyDocumentsListImpl
implements LazyUpdatableDocumentsList {
    public AbstractLazyUpdatebleDocumentsList(Session session, String nxql, String[] queryParams, String sortOrder, String schemas, int pageSize) {
        super(session, nxql, queryParams, sortOrder, schemas, pageSize);
    }

    public AbstractLazyUpdatebleDocumentsList(OperationRequest fetchOperation, String pageParametrerName) {
        super(fetchOperation, pageParametrerName);
    }

    @Override
    public void updateDocument(Document updatedDocument) {
        this.updateDocument(updatedDocument, null);
    }

    @Override
    public void updateDocument(Document updatedDocument, OperationRequest updateOperation) {
        boolean updated = false;
        int updatedPage = 0;
        final String updatedUUID = updatedDocument.getId();
        Document beforeUpdateDocument = null;
        int updatedIdx = 0;
        block0: for (Integer pageIdx : this.pages.keySet()) {
            if (updated) break;
            Documents docs = (Documents)this.pages.get(pageIdx);
            for (int i = 0; i < docs.size(); ++i) {
                if (!((Document)docs.get(i)).getId().equals(updatedDocument.getId())) continue;
                updatedIdx = i;
                beforeUpdateDocument = (Document)docs.get(i);
                docs.set(i, updatedDocument);
                updatedPage = pageIdx;
                updated = true;
                continue block0;
            }
        }
        if (updated) {
            this.getMessageHelper().notifyDocumentUpdated(updatedDocument, EventLifeCycle.CLIENT, null);
            final int page = updatedPage;
            final Document originalDocument = beforeUpdateDocument;
            final int docIdx = updatedIdx;
            if (updateOperation == null) {
                updateOperation = this.buildUpdateOperation(this.session, updatedDocument);
            }
            this.markDependencies(updateOperation, updatedDocument);
            String requestId = this.session.execDeferredUpdate(updateOperation, new AsyncCallback<Object>(){

                @Override
                public void onSuccess(String executionId, Object data) {
                    Log.i((String)AbstractLazyUpdatebleDocumentsList.class.getSimpleName(), (String)"Deferred update successful");
                    AbstractLazyUpdatebleDocumentsList.this.getClient().getTransientStateManager().flushTransientState(updatedUUID);
                    AbstractLazyUpdatebleDocumentsList.this.fetchPageAsync(page, true);
                    Log.i((String)AbstractLazyUpdatebleDocumentsList.class.getSimpleName(), (String)("Refreshing updated page " + page));
                    AbstractLazyUpdatebleDocumentsList.this.refreshAll();
                }

                @Override
                public void onError(String executionId, Throwable e) {
                    Log.i((String)AbstractLazyUpdatebleDocumentsList.class.getSimpleName(), (String)("Deferred update failed " + e.getClass().getSimpleName()));
                    if (e instanceof ConflictException) {
                        Log.i((String)AbstractLazyUpdatebleDocumentsList.class.getSimpleName(), (String)("Marking document as conflicted : " + updatedUUID));
                        AbstractLazyUpdatebleDocumentsList.this.getClient().getTransientStateManager().markAsConflict(updatedUUID);
                    } else {
                        ((Documents)AbstractLazyUpdatebleDocumentsList.this.pages.get(page)).set(docIdx, originalDocument);
                    }
                    AbstractLazyUpdatebleDocumentsList.this.notifyContentChanged(page);
                }
            }, OperationType.UPDATE);
            this.notifyContentChanged(updatedPage);
        }
    }

    @Override
    public void createDocument(Document newDocument) {
        this.createDocument(newDocument, null);
    }

    protected String addPendingCreatedDocument(Document newDoc) {
        if (this.pages.size() == 0) {
            while (this.pages.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ((Documents)this.pages.get(0)).add(0, newDoc);
        this.notifyContentChanged(0);
        return newDoc.getId();
    }

    protected void removePendingCreatedDocument(String uuid) {
        Documents docs = (Documents)this.pages.get(0);
        for (int idx = 0; idx < docs.size(); ++idx) {
            if (!((Document)docs.get(idx)).getId().equals(uuid)) continue;
            docs.remove(idx);
            break;
        }
        this.notifyContentChanged(0);
    }

    @Override
    public void createDocument(Document newDocument, OperationRequest createOperation) {
        final String key = this.addPendingCreatedDocument(newDocument);
        if (createOperation == null) {
            createOperation = this.buildCreateOperation(this.session, newDocument);
        }
        this.markDependencies(createOperation, newDocument);
        String requestId = this.session.execDeferredUpdate(createOperation, new AsyncCallback<Object>(){

            @Override
            public void onSuccess(String executionId, Object data) {
                Log.i((String)AbstractLazyUpdatebleDocumentsList.class.getSimpleName(), (String)"Deferred creation executed successfully");
                AbstractLazyUpdatebleDocumentsList.this.removePendingCreatedDocument(key);
                AbstractLazyUpdatebleDocumentsList.this.refreshAll();
            }

            @Override
            public void onError(String executionId, Throwable e) {
                AbstractLazyUpdatebleDocumentsList.this.removePendingCreatedDocument(key);
                Log.e((String)LazyUpdatableDocumentsListImpl.class.getSimpleName(), (String)"Deferred Creation failed", (Throwable)e);
            }
        }, OperationType.CREATE);
        Bundle extra = new Bundle();
        extra.putString("RequestId", requestId);
        extra.putString("SourceDocumentsList", this.getName());
        this.getMessageHelper().notifyDocumentCreated(newDocument, EventLifeCycle.CLIENT, extra);
    }

    @Override
    protected int computeTargetPage(int position) {
        if (this.pages == null || this.pages.size() == 0) {
            return 0;
        }
        if (position < ((Documents)this.pages.get(0)).size()) {
            return 0;
        }
        return 1 + (position - ((Documents)this.pages.get(0)).size()) / this.pageSize;
    }

    @Override
    protected int getRelativePositionOnPage(int globalPosition, int pageIndex) {
        if (pageIndex == 0) {
            return globalPosition;
        }
        return globalPosition - ((Documents)this.pages.get(0)).size() - (pageIndex - 1) * this.pageSize;
    }

    @Override
    protected Documents afterPageFetch(int pageIdx, Documents docs) {
        TransientStateManager tsm = ((AndroidAutomationClient)this.session.getClient()).getTransientStateManager();
        docs = tsm.mergeTransientState(docs, pageIdx == 0, this.getName());
        return docs;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected abstract OperationRequest buildUpdateOperation(Session var1, Document var2);

    protected abstract OperationRequest buildCreateOperation(Session var1, Document var2);

    protected void markDependencies(OperationRequest operation, Document doc) {
        for (String token : doc.getPendingUploads()) {
            operation.getDependencies().add(Dependency.DependencyType.FILE_UPLOAD, token);
        }
    }
}

