/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.documentprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.android.cache.sql.DocumentProviderTableWrapper;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.android.documentprovider.DocumentProvider;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyDocumentsListImpl;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsListImpl;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;

public class AndroidDocumentProvider
implements DocumentProvider {
    protected final SQLStateManager sqlStateManager;
    protected final Map<String, LazyDocumentsList> documentLists = new HashMap<String, LazyDocumentsList>();

    public AndroidDocumentProvider(SQLStateManager sqlStateManager) {
        this.sqlStateManager = sqlStateManager;
        sqlStateManager.registerWrapper(new DocumentProviderTableWrapper());
    }

    protected DocumentProviderTableWrapper getTableWrapper() {
        return (DocumentProviderTableWrapper)this.sqlStateManager.getTableWrapper("NuxeoDocumentProviders");
    }

    @Override
    public LazyDocumentsList getReadOnlyDocumentsList(String name, Session session) {
        LazyDocumentsList provider = this.documentLists.get(name);
        if (provider == null) {
            provider = this.getStoredProvider(session, name);
        }
        return provider;
    }

    @Override
    public LazyUpdatableDocumentsList getDocumentsList(String name, Session session) {
        LazyDocumentsList provider = this.getReadOnlyDocumentsList(name, session);
        if (provider != null && LazyUpdatableDocumentsList.class.isAssignableFrom(provider.getClass())) {
            return (LazyUpdatableDocumentsList)provider;
        }
        return null;
    }

    @Override
    public void registerNamedProvider(LazyDocumentsList docList, boolean persistent) {
        this.documentLists.put(docList.getName(), docList);
        if (persistent) {
            this.storeProvider(docList.getName(), docList);
        }
    }

    @Override
    public void registerNamedProvider(Session session, String name, String nxql, int pageSize, boolean readOnly, boolean persistent, String exposedMimeType) {
        LazyDocumentsListImpl docList = null;
        docList = readOnly ? new LazyDocumentsListImpl(session, nxql, null, null, null, pageSize) : new LazyUpdatableDocumentsListImpl(session, nxql, null, null, null, pageSize);
        docList.setName(name);
        if (exposedMimeType != null) {
            docList.setExposedMimeType(exposedMimeType);
        }
        this.registerNamedProvider(docList, persistent);
    }

    @Override
    public void registerNamedProvider(String name, OperationRequest fetchOperation, String pageParametrerName, boolean readOnly, boolean persistent, String exposedMimeType) {
        LazyDocumentsListImpl docList = null;
        docList = readOnly ? new LazyDocumentsListImpl(fetchOperation, pageParametrerName) : new LazyUpdatableDocumentsListImpl(fetchOperation, pageParametrerName);
        docList.setName(name);
        if (exposedMimeType != null) {
            docList.setExposedMimeType(exposedMimeType);
        }
        this.registerNamedProvider(docList, persistent);
    }

    @Override
    public void unregisterNamedProvider(String name) {
        this.documentLists.remove(name);
        this.removeStoredProvider(name);
    }

    protected void removeStoredProvider(String name) {
        this.getTableWrapper().deleteEntry(name);
    }

    protected LazyDocumentsList getStoredProvider(Session session, String name) {
        return this.getTableWrapper().getStoredProvider(session, name);
    }

    protected void storeProvider(String name, LazyDocumentsList docList) {
        this.getTableWrapper().storeProvider(name, docList);
    }

    @Override
    public List<String> listProviderNames() {
        ArrayList<String> names = new ArrayList<String>(this.documentLists.keySet());
        return names;
    }

    @Override
    public boolean isRegistred(String name) {
        return this.documentLists.containsKey(name);
    }
}

