/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.documentprovider;

import android.net.Uri;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nuxeo.android.contentprovider.NuxeoContentProviderConfig;
import org.nuxeo.android.documentprovider.DocumentsListChangeListener;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.CacheKeyHelper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;

public class LazyDocumentsListImpl
implements LazyDocumentsList {
    private static final double PREFETCH_TRIGGER = 0.5;
    protected Map<Integer, Documents> pages = new ConcurrentHashMap<Integer, Documents>();
    protected CopyOnWriteArrayList<String> loadingInProgress = new CopyOnWriteArrayList();
    protected int currentPosition = 0;
    protected int currentPage = 0;
    protected int pageCount = 0;
    protected int pageSize = 20;
    protected int totalSize = 0;
    protected String name;
    protected final Session session;
    protected OperationRequest fetchOperation;
    protected final String pageParameterName;
    protected String exposedMimeType;
    protected List<DocumentsListChangeListener> listeners = new ArrayList<DocumentsListChangeListener>();

    public LazyDocumentsListImpl(Session session, String nxql, String[] queryParams, String sortOrder, String schemas, int pageSize) {
        this.pages = new ConcurrentHashMap<Integer, Documents>();
        this.pageSize = pageSize;
        this.currentPage = 0;
        this.session = session;
        this.pageParameterName = "page";
        this.fetchOperation = session.newRequest("Document.PageProvider").set("query", nxql).set("pageSize", pageSize).set(this.pageParameterName, 0);
        if (queryParams != null) {
            this.fetchOperation.set("queryParams", queryParams);
        }
        if (schemas == null) {
            schemas = "common,dublincore";
        }
        this.fetchOperation.setHeader("X-NXDocumentProperties", schemas);
        this.name = nxql;
        this.fetchPageAsync(this.currentPage, false);
    }

    public LazyDocumentsListImpl(OperationRequest fetchOperation, String pageParametrerName) {
        this.pages = new ConcurrentHashMap<Integer, Documents>();
        this.pageParameterName = pageParametrerName;
        this.currentPage = 0;
        this.session = fetchOperation.getSession();
        this.fetchOperation = fetchOperation;
        this.fetchPageAsync(this.currentPage, false);
    }

    protected AndroidAutomationClient getClient() {
        return (AndroidAutomationClient)this.session.getClient();
    }

    protected DocumentMessageService getMessageHelper() {
        return this.getClient().getMessageHelper();
    }

    @Override
    public Documents getFirstPage() {
        return this.pages.get(0);
    }

    @Override
    public Documents getCurrentPage() {
        return this.pages.get(this.currentPage);
    }

    @Override
    public Documents fetchAndChangeCurrentPage(int targetPage) {
        if (!this.getCurrentPage().isBatched()) {
            return null;
        }
        if (targetPage >= this.getCurrentPage().getPageCount()) {
            return null;
        }
        this.currentPage = targetPage;
        return this.fetchPageSync(targetPage);
    }

    protected Documents afterPageFetch(int pageIdx, Documents docs) {
        return docs;
    }

    protected Documents fetchPageSync(int targetPage) {
        if (this.pages.containsKey(targetPage)) {
            return this.pages.get(targetPage);
        }
        Log.w((String)this.getClass().getSimpleName(), (String)("WARN -- sync fetching of new page -- " + targetPage + " ... this is very wrong !!!"));
        Documents docs = null;
        if (this.loadingInProgress.addIfAbsent("" + targetPage)) {
            docs = this.queryDocuments(targetPage, (byte)1, null);
            docs = this.afterPageFetch(targetPage, docs);
            this.pages.put(targetPage, docs);
            this.notifyContentChanged(targetPage);
            return docs;
        }
        while (this.loadingInProgress.contains("" + targetPage)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.fetchPageSync(targetPage);
    }

    protected void fetchPageAsync(final int targetPage, boolean refresh) {
        if (this.pages.containsKey(targetPage) && !refresh) {
            return;
        }
        if (this.loadingInProgress.addIfAbsent("" + targetPage)) {
            byte cacheSetting = 1;
            if (refresh) {
                cacheSetting = (byte)(cacheSetting | 2);
            }
            this.queryDocuments(targetPage, cacheSetting, new AsyncCallback<Object>(){

                @Override
                public void onError(String executionId, Throwable e) {
                    Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)"Error during async page fetching", (Throwable)e);
                    LazyDocumentsListImpl.this.loadingInProgress.remove("" + targetPage);
                }

                @Override
                public void onSuccess(String executionId, Object data) {
                    Log.i((String)LazyDocumentsListImpl.class.getSimpleName(), (String)"Page fetch successful");
                    Documents docs = (Documents)data;
                    LazyDocumentsListImpl.this.pageSize = docs.getPageSize();
                    docs = LazyDocumentsListImpl.this.afterPageFetch(targetPage, docs);
                    LazyDocumentsListImpl.this.loadingInProgress.remove("" + targetPage);
                    LazyDocumentsListImpl.this.pages.put(targetPage, docs);
                    LazyDocumentsListImpl.this.setPageCount(docs.getPageCount());
                    LazyDocumentsListImpl.this.totalSize = docs.getTotalSize();
                    LazyDocumentsListImpl.this.notifyContentChanged(targetPage);
                }
            });
        }
    }

    protected void setPageCount(int pc) {
        this.pageCount = pc;
        if (this.pageCount < this.pages.size()) {
            for (int i = this.pageCount; i < this.pages.size(); ++i) {
                this.pages.remove(i);
            }
            this.notifyContentChanged(-1);
        }
    }

    @Override
    public void refreshAll() {
        for (Integer idx : this.pages.keySet()) {
            this.fetchPageAsync(idx, true);
        }
    }

    protected void notifyContentChanged(int page) {
        for (DocumentsListChangeListener listener : this.listeners) {
            listener.notifyContentChanged(page);
        }
    }

    protected Documents queryDocuments(int page, byte cacheFlags, AsyncCallback<Object> cb) {
        try {
            if (cb == null) {
                if (this.pageParameterName != null) {
                    this.fetchOperation.set(this.pageParameterName, page);
                }
                Documents docs = (Documents)this.fetchOperation.execute(cacheFlags);
                this.pageSize = docs.getPageSize();
                this.setPageCount(docs.getPageCount());
                this.loadingInProgress.remove("" + page);
                this.totalSize = docs.getTotalSize();
                return docs;
            }
            OperationRequest asyncRequest = this.fetchOperation.clone();
            if (this.pageParameterName != null) {
                asyncRequest.set(this.pageParameterName, page);
            }
            asyncRequest.execute(cb, cacheFlags);
            return null;
        }
        catch (Exception e) {
            Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)"Error while fetching documents", (Throwable)e);
            return null;
        }
    }

    protected int computeTargetPage(int position) {
        return position / this.pageSize;
    }

    @Override
    public int getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public int setCurrentPosition(int position) {
        int targetPageIndex = this.computeTargetPage(position);
        if (targetPageIndex >= this.pageCount) {
            return this.currentPosition;
        }
        this.fetchAndChangeCurrentPage(targetPageIndex);
        this.currentPage = targetPageIndex;
        int relativePos = this.getRelativePositionOnPage(position, targetPageIndex);
        this.prefetchIfNeeded(relativePos);
        this.currentPosition = position;
        return this.currentPosition;
    }

    protected int getRelativePositionOnPage(int globalPosition, int pageIndex) {
        return globalPosition - pageIndex * this.pageSize;
    }

    protected int getRelativePositionOnPage() {
        int pos = this.getCurrentPosition();
        int targetPageIndex = this.computeTargetPage(pos);
        return this.getRelativePositionOnPage(pos, targetPageIndex);
    }

    protected void prefetchIfNeeded(int pos) {
        int pageToFetch;
        if ((double)pos > 0.5 * (double)this.pageSize && (pageToFetch = this.currentPage + 1) < this.pageCount && !this.pages.containsKey(pageToFetch)) {
            this.fetchPageAsync(pageToFetch, false);
        }
    }

    @Override
    public Document getCurrentDocument() {
        int pos = this.getRelativePositionOnPage();
        Documents currentDocs = this.getCurrentPage();
        if (currentDocs.size() > pos) {
            return (Document)currentDocs.get(pos);
        }
        for (int tryCount = 0; tryCount < 5; ++tryCount) {
            currentDocs = this.getCurrentPage();
            if (currentDocs.size() > pos) {
                return (Document)currentDocs.get(pos);
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)("global position : " + this.getCurrentPosition()));
        Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)("total size : " + this.getCurrentSize()));
        Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)("current page idex : " + this.currentPage));
        Log.e((String)LazyDocumentsListImpl.class.getSimpleName(), (String)("current page size : " + currentDocs.size()));
        throw new UnsupportedOperationException("Wrong index");
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getLoadedPageCount() {
        return this.pages.size();
    }

    @Override
    public Integer getLoadingPagesCount() {
        return this.loadingInProgress.size();
    }

    @Override
    public Iterator<Document> getIterator() {
        return new Iterator<Document>(){

            @Override
            public boolean hasNext() {
                return LazyDocumentsListImpl.this.currentPosition < LazyDocumentsListImpl.this.totalSize;
            }

            @Override
            public Document next() {
                LazyDocumentsListImpl.this.setCurrentPosition(LazyDocumentsListImpl.this.currentPosition + 1);
                return LazyDocumentsListImpl.this.getCurrentDocument();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove Document from the iterator");
            }
        };
    }

    @Override
    public Collection<Documents> getLoadedPages() {
        return this.pages.values();
    }

    @Override
    public boolean isFullyLoaded() {
        return this.pages.size() == this.pageCount;
    }

    @Override
    public int getCurrentSize() {
        if (this.getCurrentPage() == null) {
            return 0;
        }
        if (this.getCurrentPage().isBatched()) {
            int actualSize = 0;
            for (Documents docs : this.pages.values()) {
                actualSize += docs.size();
            }
            return actualSize;
        }
        return this.getCurrentPage().size();
    }

    @Override
    public void registerListener(DocumentsListChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(DocumentsListChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Document getDocument(int index) {
        int targetPage = this.computeTargetPage(index);
        int offset = index - targetPage * this.pageSize;
        if (this.pages.containsKey(targetPage)) {
            return (Document)this.pages.get(targetPage).get(offset);
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            OperationRequest rq = this.fetchOperation.clone();
            if (this.pageParameterName != null) {
                rq.set(this.pageParameterName, 0);
            }
            this.name = CacheKeyHelper.computeRequestKey(rq);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public OperationRequest getFetchOperation() {
        return this.fetchOperation;
    }

    @Override
    public String getPageParameterName() {
        return this.pageParameterName;
    }

    @Override
    public String getExposedMimeType() {
        return this.exposedMimeType;
    }

    @Override
    public void setExposedMimeType(String exposedMimeType) {
        this.exposedMimeType = exposedMimeType;
    }

    @Override
    public Uri getContentUri() {
        return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/" + this.getName()));
    }
}

