/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.download;

import android.util.Log;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.nuxeo.android.cache.blob.BlobStore;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.download.HttpBlob;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.FileBlob;
import org.nuxeo.ecm.automation.client.jaxrs.util.IOUtils;

public class FileDownloader {
    protected static final String BLOB_KEY = "blobs";
    protected static final String PICTURE_KEY = "pictures";
    protected static final String ICONS_KEY = "icons";
    protected static final String LAYOUT_KEY = "layouts";
    protected final AndroidAutomationClient client;
    protected final BlobStoreManager blobStoreManager;
    protected CopyOnWriteArrayList<String> pendingDownload = new CopyOnWriteArrayList();

    public FileDownloader(AndroidAutomationClient client) {
        this.client = client;
        this.blobStoreManager = client.getBlobStoreManager();
    }

    protected String getExecutionId(String url) {
        return "download:" + System.currentTimeMillis();
    }

    public FileBlob getBlob(String uid) {
        return this.getBlob(uid, 0);
    }

    public FileBlob getBlob(String uid, Integer idx) {
        if (idx == null) {
            idx = 0;
        }
        String pattern = "nxbigfile/default/" + uid + "/blobholder:" + idx + "/";
        String url = this.client.getServerConfig().getServerBaseUrl() + pattern;
        return this.getBlob(BLOB_KEY, url, null, null);
    }

    public FileBlob getBlob(String uid, String subPath) {
        String pattern = "nxbigfile/default/" + uid + "/" + subPath;
        String url = this.client.getServerConfig().getServerBaseUrl() + pattern;
        return this.getBlob(BLOB_KEY, url, null, null);
    }

    public FileBlob getPicture(String uid, String format) {
        String pattern = "nxpicsfile/default/" + uid + "/" + format + ":content/Android?";
        String url = this.client.getServerConfig().getServerBaseUrl() + pattern;
        return this.getBlob(PICTURE_KEY, url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBlob(String url, AsyncCallback<Blob> cb) {
        String execId = this.getExecutionId(url);
        FileBlob blob = null;
        try {
            blob = this.getBlob(BLOB_KEY, url, cb, execId);
            String string = execId;
            return string;
        }
        finally {
            if (blob != null) {
                cb.onSuccess(execId, blob);
            }
        }
    }

    public String getLayoutDefinition(String name, boolean viaDocType, String defMode) {
        String execId;
        String url = this.client.getServerConfig().getServerBaseUrl() + "site/layout-manager/layouts";
        url = viaDocType ? url + "/docType/" + name + "?mode=" + defMode : url + "?layoutName=" + name + "&mode=edit";
        FileBlob blob = this.getBlob(LAYOUT_KEY, url, null, execId = "layout:" + name);
        if (blob != null) {
            try {
                return IOUtils.read(blob.getStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read layout", e);
            }
        }
        return null;
    }

    protected String buildUrl(String suffix) {
        if (suffix.startsWith("http://") || suffix.startsWith("https://")) {
            return suffix;
        }
        String url = this.client.getServerConfig().getServerBaseUrl();
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return url + suffix;
    }

    public FileBlob getIcon(String url) {
        url = this.buildUrl(url);
        return this.getBlob(ICONS_KEY, url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIcon(String url, AsyncCallback<Blob> cb) {
        String execId = this.getExecutionId(url);
        FileBlob blob = null;
        try {
            blob = this.getBlob(ICONS_KEY, url, cb, execId);
            String string = execId;
            return string;
        }
        finally {
            if (blob != null) {
                cb.onSuccess(execId, blob);
            }
        }
    }

    protected String getRequestKey(String url) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(url.getBytes());
        byte[] messageDigest = digest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    protected FileBlob getBlob(String assetType, String url, AsyncCallback<Blob> cb, String execId) {
        String key;
        BlobStore store = this.blobStoreManager.getBlobStore(assetType);
        FileBlob blob = store.getBlob(key = this.getRequestKey(url));
        if (blob != null) {
            return blob;
        }
        if (!this.client.isOffline()) {
            blob = this.downloadAndStoreBlob(store, url, key, cb, execId);
        }
        return blob;
    }

    protected FileBlob downloadAndStoreBlob(final BlobStore store, final String url, final String key, final AsyncCallback<Blob> cb, final String execId) {
        boolean added = this.pendingDownload.addIfAbsent(url);
        if (added) {
            this.client.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HttpResponse response = FileDownloader.this.client.getConnector().executeSimpleHttp((HttpUriRequest)new HttpGet(url));
                        Blob file = null;
                        if (response.getStatusLine().getStatusCode() == 200) {
                            file = store.storeBlob(key, new HttpBlob(response));
                        } else {
                            Log.e((String)FileDownloader.class.getSimpleName(), (String)("Can not download file, return code " + response.getStatusLine().getStatusCode()));
                        }
                        if (cb != null) {
                            cb.onSuccess(execId, file);
                        }
                    }
                    catch (Exception e) {
                        if (cb != null) {
                            cb.onError(execId, e);
                        }
                    }
                    finally {
                        FileDownloader.this.pendingDownload.remove(url);
                    }
                }
            });
        } else if (cb != null) {
            this.client.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileBlob blob = FileDownloader.this.waitUntilCompletion(store, key, url);
                    cb.onSuccess(execId, blob);
                }
            });
        }
        if (cb == null) {
            return this.waitUntilCompletion(store, key, url);
        }
        return null;
    }

    protected FileBlob waitUntilCompletion(BlobStore store, String key, String url) {
        while (this.pendingDownload.contains(url)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return store.getBlob(key);
    }
}

