/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import java.io.Serializable;
import org.nuxeo.android.fragments.BaseDocumentsListFragment;
import org.nuxeo.android.fragments.BaseNuxeoFragment;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.NuxeoLayout;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocumentStatus;
import org.nuxeo.ecm.automation.client.jaxrs.model.IdRef;

public abstract class BaseDocumentLayoutFragment
extends BaseNuxeoFragment {
    public static final String DOCUMENT = "document";
    public static final String MODE = "mode";
    public static final String FIRST_CALL = "first call";
    public static final String FRAGMENT_CONTAINER_ID = "fragContainerId";
    protected Document currentDocument;
    protected Intent callingIntent;
    protected boolean requireAsyncFetch = true;
    public static final int MNU_SWITCH_EDIT = 1000;
    public static final int MNU_SWITCH_VIEW = 1001;
    protected NuxeoLayout layout;
    protected BaseDocumentLayoutFragment documentLayoutFragment = null;
    protected static final int ACTION_EDIT_DOCUMENT = 0;
    Integer containerId = null;
    protected Callback mCallback;

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.buildLayout();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isCreateMode()) {
            this.requireAsyncFetch = false;
        } else if (this.getCurrentDocument().getStatusFlag() != DocumentStatus.SYNCHRONIZED) {
            this.requireAsyncFetch = false;
        }
        if (this.isEditMode()) {
            this.getActivity().setTitle((CharSequence)"Edit ");
        } else if (this.isCreateMode()) {
            this.getActivity().setTitle((CharSequence)"Create");
        } else {
            this.getActivity().setTitle((CharSequence)"View ");
        }
    }

    protected abstract ViewGroup getLayoutContainer();

    protected void buildLayout() {
        this.layout = this.getAutomationClient().getLayoutService().getLayout(this, this.getCurrentDocument(), this.getLayoutContainer(), this.getMode());
    }

    protected Document getCurrentDocument() {
        if (this.currentDocument == null) {
            Bundle args = this.getArguments();
            this.currentDocument = (Document)args.getSerializable(DOCUMENT);
        }
        return this.currentDocument;
    }

    protected LayoutMode getMode() {
        Bundle args = this.getArguments();
        return (LayoutMode)args.getSerializable(MODE);
    }

    protected boolean isCreateMode() {
        return this.getMode() == LayoutMode.CREATE;
    }

    protected boolean isEditMode() {
        return this.getMode() == LayoutMode.EDIT;
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        if (this.getActivity() != null && this.getActivity().getBaseContext() != null) {
            this.currentDocument = (Document)data;
            if (this.layout == null) {
                Toast.makeText((Context)this.getActivity().getBaseContext(), (CharSequence)"Unable to get Layout", (int)0).show();
            } else {
                this.layout.refreshFromDocument(this.currentDocument);
                Toast.makeText((Context)this.getActivity().getBaseContext(), (CharSequence)"Refreshed document", (int)0).show();
            }
            this.requireAsyncFetch = false;
            if (this.isEditMode()) {
                this.getActivity().setTitle((CharSequence)("Edit " + this.getCurrentDocument().getType() + " " + this.getCurrentDocument().getTitle()));
            } else if (this.isCreateMode()) {
                this.getActivity().setTitle((CharSequence)("Create new " + this.getCurrentDocument().getType()));
            } else {
                this.getActivity().setTitle((CharSequence)("View " + this.getCurrentDocument().getType() + " " + this.getCurrentDocument().getTitle()));
            }
            this.setHasOptionsMenu(true);
        }
    }

    @Override
    protected Object retrieveNuxeoData() throws Exception {
        Document refreshedDocument = this.getNuxeoContext().getDocumentManager().getDocument((DocRef)new IdRef(this.getCurrentDocument().getId()), true);
        return refreshedDocument;
    }

    @Override
    protected boolean requireAsyncDataRetrieval() {
        return this.requireAsyncFetch;
    }

    protected NuxeoLayout getLayout() {
        if (this.layout == null) {
            this.buildLayout();
        }
        return this.layout;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.getLayout() != null) {
            this.layout.onActivityResult(requestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void saveDocument() {
        Document doc = this.getCurrentDocument();
        this.getLayout().applyChanges(doc);
        LayoutMode mode = (LayoutMode)this.getArguments().getSerializable(MODE);
        if (mode == LayoutMode.EDIT) {
            if (this.mCallback.isTwoPane()) {
                BaseDocumentsListFragment listFragment = (BaseDocumentsListFragment)this.getFragmentManager().findFragmentById(this.mCallback.getListFragmentContainerId());
                listFragment.saveDocument(doc);
            } else {
                this.getActivity().setResult(-1, new Intent().putExtra(DOCUMENT, (Serializable)doc));
                this.getActivity().finish();
            }
        } else if (this.mCallback.isTwoPane()) {
            BaseDocumentsListFragment listFragment = (BaseDocumentsListFragment)this.getFragmentManager().findFragmentById(this.mCallback.getListFragmentContainerId());
            listFragment.saveNewDocument(doc);
        } else {
            this.getActivity().setResult(-1, new Intent().putExtra(DOCUMENT, (Serializable)doc));
            this.getActivity().finish();
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        if (Build.VERSION.SDK_INT >= 11) {
            if (LayoutMode.VIEW == this.getMode()) {
                if (this.mCallback.isTwoPane()) {
                    menu.add(0, 1000, 2, (CharSequence)"Edit").setShowAsAction(1);
                } else {
                    menu.add(0, 1000, 2, (CharSequence)"Edit Document").setShowAsAction(1);
                }
            }
            if (LayoutMode.EDIT == this.getMode()) {
                if (this.mCallback.isTwoPane()) {
                    menu.add(0, 1001, 2, (CharSequence)"View").setShowAsAction(1);
                } else {
                    menu.add(0, 1001, 2, (CharSequence)"Back to View").setShowAsAction(1);
                }
            }
        } else {
            if (LayoutMode.VIEW == this.getMode()) {
                menu.add(0, 1000, 0, (CharSequence)"Switch to Edit");
            }
            if (LayoutMode.EDIT == this.getMode()) {
                menu.add(0, 1001, 0, (CharSequence)"Switch to View");
            }
        }
        super.onCreateOptionsMenu(menu, inflater);
    }

    public boolean isFirstCall() {
        return this.getArguments().getBoolean(FIRST_CALL);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof Callback)) {
            throw new IllegalStateException("Activity must implement fragment's callbacks.");
        }
        this.mCallback = (Callback)activity;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        super.onOptionsItemSelected(item);
        if (item.getItemId() == 1000 || item.getItemId() == 1001) {
            this.exchangeFragments();
        }
        return true;
    }

    private void exchangeFragments() {
        Bundle args = this.getArguments();
        args.putSerializable(DOCUMENT, (Serializable)this.currentDocument);
        if (this.isEditMode()) {
            args.putSerializable(MODE, (Serializable)LayoutMode.VIEW);
        } else {
            args.putSerializable(MODE, (Serializable)LayoutMode.EDIT);
        }
        args.putBoolean(FIRST_CALL, false);
        args.putInt(FRAGMENT_CONTAINER_ID, this.getContainerId());
        this.getDocumentLayoutFragment().setArguments(args);
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(this.getContainerId(), (Fragment)this.getDocumentLayoutFragment());
        transaction.commit();
    }

    public abstract BaseDocumentLayoutFragment getDocumentLayoutFragment();

    protected int getContainerId() {
        if (this.containerId == null) {
            this.containerId = this.mCallback.getLayoutFragmentContainerId();
        }
        return this.containerId;
    }

    public static interface Callback {
        public int getLayoutFragmentContainerId();

        public boolean isTwoPane();

        public int getListFragmentContainerId();
    }
}

