/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.Toast;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.fragments.BaseDocLayoutFragAct;
import org.nuxeo.android.fragments.BaseDocumentLayoutFragment;
import org.nuxeo.android.fragments.BaseListFragment;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.ecm.automation.client.cache.DeferredUpdateManager;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.impl.NotAvailableOffline;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public abstract class BaseDocumentsListFragment
extends BaseListFragment {
    public static final int ACTION_EDIT_DOCUMENT = 0;
    protected static final int ACTION_CREATE_DOCUMENT = 1;
    protected static final int MNU_NEW_LISTITEM = 10;
    protected static final int MNU_SORT = 100;
    protected static final int MNU_REFRESH = 2;
    protected static final int CTXMNU_VIEW_DOCUMENT = 0;
    protected static final int CTXMNU_EDIT_DOCUMENT = 1;
    protected static final int CTXMNU_VIEW_ATTACHEMENT = 2;
    protected static final int CTXMNU_DELETE = 3;
    protected boolean refresh = false;
    protected LazyUpdatableDocumentsList documentsList;
    protected LinkedHashMap<String, String> allowedDocumentTypes;
    protected Callback mCallback;

    @Override
    protected Object retrieveNuxeoData() throws Exception {
        byte cacheParam = 1;
        if (this.refresh) {
            cacheParam = (byte)(cacheParam | 2);
            this.refresh = false;
        }
        return this.fetchDocumentsList(cacheParam, "");
    }

    protected void forceRefresh() {
        this.refresh = true;
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        super.onNuxeoDataRetrieved(data);
        DeferredUpdateManager dum = this.getAutomationClient().getDeferredUpdatetManager();
        if (dum.getPendingRequestCount() > 0L) {
            dum.executePendingRequests(this.getNuxeoSession(), new Handler(){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                }
            });
        }
        if (data != null) {
            this.documentsList = (LazyUpdatableDocumentsList)data;
            this.displayDocumentList(this.listView, this.documentsList);
        }
        this.doRefresh();
    }

    @Override
    public void doRefresh() {
        if (this.documentsList != null) {
            this.documentsList.refreshAll();
        } else {
            this.runAsyncDataRetrieval();
        }
    }

    protected LazyDocumentsList getDocumentsList() {
        return this.documentsList;
    }

    @Override
    public boolean isReady() {
        if (super.isReady()) {
            if (this.documentsList != null) {
                return this.documentsList.getLoadingPagesCount() == 0 && this.documentsList.getLoadedPageCount() > 0;
            }
            return false;
        }
        return false;
    }

    protected abstract LazyUpdatableDocumentsList fetchDocumentsList(byte var1, String var2) throws Exception;

    @Deprecated
    protected LazyUpdatableDocumentsList fetchDocumentsList(byte cacheParam) throws Exception {
        return this.fetchDocumentsList(cacheParam, "");
    }

    protected abstract void displayDocumentList(ListView var1, LazyDocumentsList var2);

    protected abstract Document initNewDocument(String var1);

    protected abstract Class<? extends BaseDocLayoutFragAct> getEditActivityClass();

    protected void onDocumentCreate(Document newDocument) {
        this.documentsList.createDocument(newDocument);
    }

    public void onDocumentUpdate(Document editedDocument) {
        this.documentsList.updateDocument(editedDocument);
    }

    protected Document getContextMenuDocument(int selectedPosition) {
        return this.documentsList.getDocument(selectedPosition);
    }

    protected void registerDocTypesForCreation(String type, String label) {
        if (this.allowedDocumentTypes == null) {
            this.allowedDocumentTypes = new LinkedHashMap();
        }
        this.allowedDocumentTypes.put(type, label);
    }

    protected LinkedHashMap<String, String> getDocTypesForCreation() {
        if (this.allowedDocumentTypes == null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("File", "File Document");
            map.put("Note", "Note Document");
            map.put("Folder", "Folder Document");
            return map;
        }
        return this.allowedDocumentTypes;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2: {
                this.doRefresh();
                break;
            }
            case 101: {
                new NuxeoListAsyncTask().execute(new String[]{" order by dc:title asc"});
                break;
            }
            case 102: {
                new NuxeoListAsyncTask().execute(new String[]{" order by dc:title desc"});
                break;
            }
            case 103: {
                new NuxeoListAsyncTask().execute(new String[]{" order by dc:modified desc"});
                break;
            }
            case 104: {
                new NuxeoListAsyncTask().execute(new String[]{" order by dc:modified"});
                break;
            }
            default: {
                if (item.getItemId() > 10) {
                    int idx = item.getItemId() - 10 - 1;
                    if (idx >= this.getDocTypesForCreation().size()) break;
                    String type = new ArrayList<String>(this.getDocTypesForCreation().keySet()).get(idx);
                    this.forceRefresh();
                    Document newDoc = this.initNewDocument(type);
                    if (newDoc == null) break;
                    this.openDocument(newDoc, LayoutMode.CREATE);
                    break;
                }
                if (item.getItemId() != 10 || this.getDocTypesForCreation().size() != 1) break;
                this.forceRefresh();
                Document newDoc = this.initNewDocument(this.getDocTypesForCreation().keySet().iterator().next());
                if (newDoc == null) break;
                this.openDocument(newDoc, LayoutMode.CREATE);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof Callback)) {
            throw new IllegalStateException("Activity must implement fragment's callbacks.");
        }
        this.mCallback = (Callback)activity;
    }

    @Override
    public void onResume() {
        this.listView.setAdapter(null);
        super.onResume();
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int selectedPosition = info.position;
        Document doc = this.getContextMenuDocument(selectedPosition);
        if (item.getItemId() == 0) {
            this.openDocument(doc, LayoutMode.VIEW);
            return true;
        }
        if (item.getItemId() == 1) {
            this.openDocument(doc, LayoutMode.EDIT);
            return true;
        }
        if (item.getItemId() == 2) {
            Uri blobUri = doc.getBlob();
            if (blobUri == null) {
                Toast.makeText((Context)this.getActivity().getBaseContext(), (CharSequence)"No Attachement available ", (int)0).show();
            } else {
                this.startViewerFromBlob(blobUri);
            }
            return true;
        }
        if (item.getItemId() == 3) {
            this.deleteDocument(doc);
            this.doRefresh();
            return true;
        }
        return super.onContextItemSelected(item);
    }

    protected void deleteDocument(Document doc) {
        OperationRequest request = this.getNuxeoSession().newRequest("Document.SetLifeCycle");
        request.setInput(doc);
        request.set("value", "delete");
        this.documentsList.updateDocument(doc, request);
    }

    @Override
    protected void onListItemClicked(int listItemPosition) {
        this.openDocument(this.documentsList.getDocument(listItemPosition), LayoutMode.VIEW);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        LinkedHashMap<String, String> types = this.getDocTypesForCreation();
        if (Build.VERSION.SDK_INT >= 11) {
            SubMenu subMenu = menu.addSubMenu(0, 100, 0, (CharSequence)"sort");
            subMenu.add(0, 101, 0, (CharSequence)"A - z");
            subMenu.add(0, 102, 1, (CharSequence)"z - A");
            subMenu.add(0, 103, 2, (CharSequence)"last modification up");
            subMenu.add(0, 104, 3, (CharSequence)"last modification down");
            subMenu.getItem().setShowAsAction(1);
            if (types.size() > 0) {
                if (types.size() == 1) {
                    menu.add(0, 10, 0, (CharSequence)"New Item").setShowAsAction(1);
                } else {
                    subMenu = menu.addSubMenu(0, 10, 0, (CharSequence)"New item");
                    subMenu.getItem().setShowAsAction(1);
                    int idx = 1;
                    for (String key : types.keySet()) {
                        subMenu.add(0, 10 + idx, idx, (CharSequence)types.get(key));
                        ++idx;
                    }
                }
            }
            menu.add(0, 2, 1, (CharSequence)"Refresh").setShowAsAction(1);
        } else {
            SubMenu subMenu = menu.addSubMenu(0, 100, 0, (CharSequence)"New item");
            menu.add(0, 100, 0, (CharSequence)"Sort");
            subMenu.add(0, 101, 0, (CharSequence)"A - Z");
            subMenu.add(0, 102, 1, (CharSequence)"Z - A");
            subMenu.add(0, 103, 2, (CharSequence)"last modification up");
            subMenu.add(0, 104, 3, (CharSequence)"last modification down");
            if (types.size() > 0) {
                if (types.size() == 1) {
                    menu.add(0, 10, 0, (CharSequence)"New Item");
                } else {
                    subMenu = menu.addSubMenu(0, 10, 0, (CharSequence)"New item");
                    subMenu.getItem();
                    int idx = 1;
                    for (String key : types.keySet()) {
                        subMenu.add(0, 10 + idx, idx, (CharSequence)types.get(key));
                        ++idx;
                    }
                }
            }
            menu.add(0, 2, 1, (CharSequence)"Refresh");
        }
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (v.getId() == this.listView.getId()) {
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
            Document doc = this.documentsList.getDocument(info.position);
            menu.setHeaderTitle((CharSequence)doc.getTitle());
            this.populateContextMenu(doc, menu);
        }
        super.onCreateContextMenu(menu, v, menuInfo);
    }

    protected void populateContextMenu(Document doc, ContextMenu menu) {
        menu.add(0, 0, 0, (CharSequence)"View");
        menu.add(0, 1, 1, (CharSequence)"Edit");
        menu.add(0, 2, 2, (CharSequence)"View attachment");
        menu.add(0, 3, 2, (CharSequence)"Delete");
    }

    public void openDocument(Document doc, LayoutMode mode) {
        if (this.mCallback.isTwoPane()) {
            BaseDocumentLayoutFragment documentLayoutFrag = this.mCallback.getLayoutFragment();
            FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
            Bundle args = new Bundle();
            args.putSerializable("document", (Serializable)doc);
            args.putSerializable("mode", (Serializable)mode);
            args.putBoolean("first call", true);
            args.putInt("fragContainerId", this.mCallback.getLayoutFragmentContainerId());
            documentLayoutFrag.setArguments(args);
            transaction.replace(this.mCallback.getLayoutFragmentContainerId(), (Fragment)documentLayoutFrag);
            transaction.commit();
        } else {
            Intent intent = new Intent(new Intent(this.getActivity().getBaseContext(), this.mCallback.getLayoutFragmentActivity()).putExtra("document", (Serializable)doc).putExtra("mode", (Serializable)mode).putExtra("first call", true));
            if (mode == LayoutMode.CREATE) {
                this.startActivityForResult(intent, 1);
            } else {
                this.startActivityForResult(intent, 0);
            }
        }
    }

    public void saveDocument(Document doc) {
        this.onDocumentUpdate(doc);
        this.doRefresh();
        if (this.mCallback.isTwoPane()) {
            FragmentManager fragManager = this.getFragmentManager();
            FragmentTransaction transaction = fragManager.beginTransaction();
            transaction.detach(fragManager.findFragmentById(this.mCallback.getLayoutFragmentContainerId()));
            transaction.commit();
        }
    }

    public void saveNewDocument(Document doc) {
        this.onDocumentCreate(doc);
        if (this.mCallback.isTwoPane()) {
            FragmentManager fragManager = this.getFragmentManager();
            FragmentTransaction transaction = fragManager.beginTransaction();
            transaction.remove(fragManager.findFragmentById(this.mCallback.getLayoutFragmentContainerId()));
            transaction.commit();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            if (data.hasExtra("document")) {
                Document editedDocument = (Document)data.getExtras().get("document");
                BaseDocumentsListFragment listFragment = (BaseDocumentsListFragment)this.getFragmentManager().findFragmentById(this.mCallback.getListFragmentContainerId());
                listFragment.saveDocument(editedDocument);
            }
        } else if (requestCode == 1 && resultCode == -1 && data.hasExtra("document")) {
            Document newDocument = (Document)data.getExtras().get("document");
            this.saveNewDocument(newDocument);
        }
    }

    protected class NuxeoListAsyncTask
    extends AsyncTask<String, Integer, Object> {
        protected NuxeoListAsyncTask() {
        }

        protected void onPreExecute() {
            BaseDocumentsListFragment.this.loadingInProgress = true;
            BaseDocumentsListFragment.this.onNuxeoDataRetrievalStarted();
            super.onPreExecute();
        }

        protected Object retrieveNuxeoData(String order) throws Exception {
            byte cacheParam = 1;
            if (BaseDocumentsListFragment.this.refresh) {
                cacheParam = (byte)(cacheParam | 2);
                BaseDocumentsListFragment.this.refresh = false;
            }
            return BaseDocumentsListFragment.this.fetchDocumentsList(cacheParam, order);
        }

        protected Object doInBackground(String ... arg0) {
            try {
                Object result = this.retrieveNuxeoData(arg0[0]);
                return result;
            }
            catch (NotAvailableOffline naoe) {
                BaseDocumentsListFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)BaseDocumentsListFragment.this.getActivity().getBaseContext(), (CharSequence)"This screen can bot be displayed offline", (int)1).show();
                    }
                });
                return null;
            }
            catch (Exception e) {
                Log.e((String)"NuxeoAsyncTask", (String)"Error while executing async Nuxeo task in activity", (Throwable)e);
                try {
                    this.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }

        protected void onPostExecute(Object result) {
            BaseDocumentsListFragment.this.loadingInProgress = false;
            if (result != null) {
                BaseDocumentsListFragment.this.onNuxeoDataRetrieved(result);
            } else {
                BaseDocumentsListFragment.this.onNuxeoDataRetrieveFailed();
            }
        }
    }

    public static interface Callback {
        public boolean isTwoPane();

        public int getLayoutFragmentContainerId();

        public Class<? extends Activity> getLayoutFragmentActivity();

        public BaseDocumentLayoutFragment getLayoutFragment();

        public int getListFragmentContainerId();
    }
}

