/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.fragments;

import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import org.nuxeo.android.fragments.BaseNuxeoFragment;

public abstract class BaseListFragment
extends BaseNuxeoFragment
implements AdapterView.OnItemClickListener {
    protected ListView listView;
    protected TextView waitingMessage;
    protected boolean refresh = false;

    @Override
    protected boolean requireAsyncDataRetrieval() {
        return true;
    }

    public void onViewCreated(View v, Bundle savedInstanceState) {
        super.onViewCreated(v, savedInstanceState);
        if (this.listView != null) {
            this.registerForContextMenu((View)this.listView);
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
    }

    protected void setupViewsOnDataLoading() {
        if (this.waitingMessage != null) {
            this.waitingMessage.setText((CharSequence)"Loading data ...");
            this.waitingMessage.setVisibility(0);
        }
    }

    protected void setupViewsOnDataLoaded() {
        if (this.waitingMessage != null) {
            this.waitingMessage.setVisibility(8);
        }
    }

    @Override
    protected void onNuxeoDataRetrievalStarted() {
        this.setupViewsOnDataLoading();
    }

    @Override
    protected void onNuxeoDataRetrieved(Object data) {
        this.setupViewsOnDataLoaded();
    }

    @Override
    protected void onNuxeoDataRetrieveFailed() {
        this.setupViewsOnDataLoaded();
    }

    public void onItemClick(AdapterView<?> list, View container, int position, long id) {
        this.onListItemClicked(position);
    }

    protected abstract void onListItemClicked(int var1);

    protected abstract void doRefresh();
}

