/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import java.io.File;
import org.nuxeo.android.context.NuxeoContext;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.NotAvailableOffline;

public abstract class BaseNuxeoFragment
extends Fragment {
    protected boolean loadingInProgress = false;

    protected NuxeoContext getNuxeoContext() {
        return NuxeoContext.get(this.getActivity().getApplicationContext());
    }

    protected Session getNuxeoSession() {
        return this.getNuxeoContext().getSession();
    }

    protected AndroidAutomationClient getAutomationClient() {
        return this.getNuxeoContext().getNuxeoClient();
    }

    protected abstract boolean requireAsyncDataRetrieval();

    public void onResume() {
        super.onResume();
        if (this.requireAsyncDataRetrieval()) {
            this.runAsyncDataRetrieval();
        }
    }

    protected void runAsyncDataRetrieval() {
        new NuxeoAsyncTask().execute(null);
    }

    protected Object retrieveNuxeoData() throws Exception {
        return null;
    }

    protected void onNuxeoDataRetrievalStarted() {
    }

    protected void onNuxeoDataRetrieved(Object data) {
    }

    protected void onNuxeoDataRetrieveFailed() {
    }

    protected void startViewerFromBlob(File tmpFile, String mimeTye) {
        Uri path = Uri.fromFile((File)tmpFile);
        this.startViewerFromBlob(path, mimeTye);
    }

    protected void startViewerFromBlob(Uri uri, String mimeTye) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, mimeTye);
        intent.setFlags(0x4000000);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this.getActivity().getBaseContext(), (CharSequence)("No Application Available to View " + mimeTye), (int)0).show();
        }
    }

    protected void startViewerFromBlob(Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        intent.setFlags(0x4000000);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this.getActivity().getBaseContext(), (CharSequence)("No Application Available to View uri " + uri.toString()), (int)0).show();
        }
    }

    protected void unbindDrawables(View view) {
        if (view.getBackground() != null) {
            view.getBackground().setCallback(null);
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.unbindDrawables(((ViewGroup)view).getChildAt(i));
            }
            try {
                ((ViewGroup)view).removeAllViews();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected <T> T getInitParam(String name, Class<T> type) {
        Object value;
        if (this.getActivity().getIntent().getExtras() != null && (value = this.getActivity().getIntent().getExtras().get(name)) != null) {
            return type.cast(value);
        }
        return null;
    }

    protected <T> T getInitFragmentParam(String name, Class<T> type) {
        Object value;
        if (this.getArguments() != null && (value = this.getArguments().get(name)) != null) {
            return type.cast(value);
        }
        return null;
    }

    public boolean isReady() {
        return !this.loadingInProgress;
    }

    protected class NuxeoAsyncTask
    extends AsyncTask<Void, Integer, Object> {
        protected NuxeoAsyncTask() {
        }

        protected void onPreExecute() {
            BaseNuxeoFragment.this.loadingInProgress = true;
            BaseNuxeoFragment.this.onNuxeoDataRetrievalStarted();
            super.onPreExecute();
        }

        protected Object doInBackground(Void ... arg0) {
            try {
                Object result = BaseNuxeoFragment.this.retrieveNuxeoData();
                return result;
            }
            catch (NotAvailableOffline naoe) {
                BaseNuxeoFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)BaseNuxeoFragment.this.getActivity().getBaseContext(), (CharSequence)"This screen can bot be displayed offline", (int)1).show();
                    }
                });
                return null;
            }
            catch (Exception e) {
                Log.e((String)"NuxeoAsyncTask", (String)"Error while executing async Nuxeo task in activity", (Throwable)e);
                try {
                    this.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }

        protected void onPostExecute(Object result) {
            BaseNuxeoFragment.this.loadingInProgress = false;
            if (result != null) {
                BaseNuxeoFragment.this.onNuxeoDataRetrieved(result);
            } else {
                BaseNuxeoFragment.this.onNuxeoDataRetrieveFailed();
            }
        }
    }
}

