/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.view.ViewGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.android.download.FileDownloader;
import org.nuxeo.android.layout.LayoutDefinition;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.NuxeoLayout;
import org.nuxeo.android.layout.NuxeoLayoutService;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class AndroidLayoutService
implements NuxeoLayoutService {
    protected static final String DOCTYPE_PREFIX = "doctype:";
    protected Map<String, LayoutDefinition> definitions = new HashMap<String, LayoutDefinition>();
    protected final FileDownloader downloader;
    protected static final List<String> builtinTypes = Arrays.asList("File", "Folder", "Workspace", "Domain", "Note", "Picture");

    public AndroidLayoutService(FileDownloader downloader) {
        this.downloader = downloader;
    }

    protected FileDownloader getFileDownloader() {
        return this.downloader;
    }

    protected String getLayoutDefinitionModeForType(LayoutMode mode, String docType) {
        if (builtinTypes.contains(docType)) {
            return "edit";
        }
        return mode.toString();
    }

    @Override
    public NuxeoLayout getLayout(Fragment fragment, Document doc, ViewGroup parent, LayoutMode mode) {
        return this.getLayout(fragment, doc, parent, mode, null);
    }

    @Override
    public NuxeoLayout getLayout(Activity ctx, Document doc, ViewGroup parent, LayoutMode mode) {
        String nullString = null;
        return this.getLayout(ctx, doc, parent, mode, nullString);
    }

    @Override
    public NuxeoLayout getLayout(Activity ctx, Document doc, ViewGroup parent, LayoutMode mode, String layoutName) {
        LayoutDefinition def;
        boolean useDocType = false;
        String defMode = null;
        if (layoutName == null) {
            useDocType = true;
            defMode = this.getLayoutDefinitionModeForType(mode, doc.getType());
            layoutName = DOCTYPE_PREFIX + doc.getType() + defMode;
        }
        if ((def = this.definitions.get(layoutName)) == null) {
            def = useDocType ? this.loadLayout(doc.getType(), true, defMode) : this.loadLayout(layoutName, false, null);
        }
        if (def != null) {
            return def.buildLayout(ctx, doc, parent, mode);
        }
        return null;
    }

    @Override
    public NuxeoLayout getLayout(Fragment fragment, Document doc, ViewGroup parent, LayoutMode mode, String layoutName) {
        LayoutDefinition def;
        boolean useDocType = false;
        String defMode = null;
        if (layoutName == null) {
            useDocType = true;
            defMode = this.getLayoutDefinitionModeForType(mode, doc.getType());
            layoutName = DOCTYPE_PREFIX + doc.getType() + defMode;
        }
        if ((def = this.definitions.get(layoutName)) == null) {
            def = useDocType ? this.loadLayout(doc.getType(), true, defMode) : this.loadLayout(layoutName, false, null);
        }
        if (def != null) {
            return def.buildLayout(fragment, doc, parent, mode);
        }
        return null;
    }

    protected LayoutDefinition loadLayout(String layoutName, boolean docType, String defMode) {
        String jsonLayout = this.getFileDownloader().getLayoutDefinition(layoutName, docType, defMode);
        if (jsonLayout == null) {
            return null;
        }
        LayoutDefinition layoutDefinition = this.parse(jsonLayout);
        if (layoutDefinition != null) {
            String key = layoutName;
            if (docType) {
                key = DOCTYPE_PREFIX + key + defMode;
            }
            this.definitions.put(key, layoutDefinition);
        }
        return layoutDefinition;
    }

    protected LayoutDefinition parse(String jsonLayoutDef) {
        return LayoutDefinition.fromJSON(jsonLayoutDef);
    }

    @Override
    public NuxeoLayout parseLayoutDefinition(String definition, Fragment fragment, Document doc, ViewGroup parent, LayoutMode mode) {
        LayoutDefinition layoutDefinition = this.parse(definition);
        return layoutDefinition.buildLayout(fragment, doc, parent, mode);
    }

    @Override
    public NuxeoLayout parseLayoutDefinition(String definition, Activity ctx, Document doc, ViewGroup parent, LayoutMode mode) {
        LayoutDefinition layoutDefinition = this.parse(definition);
        return layoutDefinition.buildLayout(ctx, doc, parent, mode);
    }
}

