/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutJSONParser;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.LayoutRow;
import org.nuxeo.android.layout.NuxeoLayout;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class LayoutDefinition {
    protected Map<String, WidgetDefinition> widgetDefs = new HashMap<String, WidgetDefinition>();
    protected List<LayoutRow> rows = new ArrayList<LayoutRow>();

    public static LayoutDefinition fromJSON(String jsonString) {
        try {
            return LayoutJSONParser.readDefinition(jsonString);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public LayoutDefinition(Map<String, WidgetDefinition> widgetDefs, List<LayoutRow> rows) {
        this.widgetDefs = widgetDefs;
        this.rows = rows;
    }

    public NuxeoLayout buildLayout(Fragment fragment, Document doc, ViewGroup parent, LayoutMode mode) {
        ViewGroup container = this.createTopLayoutContainer((Context)fragment.getActivity(), parent);
        LayoutContext context = new LayoutContext((Activity)fragment.getActivity(), container, fragment);
        NuxeoLayout layout = new NuxeoLayout(context, doc);
        try {
            for (LayoutRow row : this.rows) {
                layout.addWidgets(row.buildRow(context, doc, container, this.widgetDefs, mode));
            }
        }
        catch (Throwable t) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Error during Layout definition parsing", (Throwable)t);
        }
        return layout;
    }

    public NuxeoLayout buildLayout(Activity ctx, Document doc, ViewGroup parent, LayoutMode mode) {
        ViewGroup container = this.createTopLayoutContainer((Context)ctx, parent);
        LayoutContext context = new LayoutContext(ctx, container);
        NuxeoLayout layout = new NuxeoLayout(context, doc);
        try {
            for (LayoutRow row : this.rows) {
                layout.addWidgets(row.buildRow(context, doc, container, this.widgetDefs, mode));
            }
        }
        catch (Throwable t) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Error during Layout definition parsing", (Throwable)t);
        }
        return layout;
    }

    protected ViewGroup createTopLayoutContainer(Context ctx, ViewGroup parent) {
        LinearLayout container = new LinearLayout(ctx);
        container.setOrientation(1);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        container.setLayoutParams((ViewGroup.LayoutParams)params);
        parent.addView((View)container);
        return container;
    }

    public void merge(LayoutDefinition def) {
        this.widgetDefs.putAll(def.widgetDefs);
        this.rows.addAll(def.rows);
    }
}

