/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.android.layout.LayoutDefinition;
import org.nuxeo.android.layout.LayoutRow;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.selectOptions.SelectOptions;

public class LayoutJSONParser {
    public static final String WIDGETS_DEF = "widgets";
    public static final String ROWS_DEF = "rows";
    public static final String OPTIONS_DEF = "selectOptions";

    public static LayoutDefinition readDefinition(String jsonString) throws JSONException {
        if ((jsonString = jsonString.trim()).startsWith("[")) {
            LayoutDefinition globalDefinition = null;
            JSONArray array = new JSONArray(jsonString);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                LayoutDefinition def = LayoutJSONParser.readDefinition(jsonObject);
                if (globalDefinition == null) {
                    globalDefinition = def;
                    continue;
                }
                globalDefinition.merge(def);
            }
            return globalDefinition;
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        return LayoutJSONParser.readDefinition(jsonObject);
    }

    public static LayoutDefinition readDefinition(JSONObject jsonObject) throws JSONException {
        int i;
        JSONArray widgets = jsonObject.getJSONArray(WIDGETS_DEF);
        JSONArray rows = jsonObject.getJSONArray(ROWS_DEF);
        HashMap<String, WidgetDefinition> widgetDefs = new HashMap<String, WidgetDefinition>();
        ArrayList<LayoutRow> rowDefs = new ArrayList<LayoutRow>();
        for (i = 0; i < widgets.length(); ++i) {
            try {
                JSONObject w = widgets.getJSONObject(i);
                JSONArray fields = w.getJSONArray("fields");
                JSONObject labels = w.getJSONObject("labels");
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (int j = 0; j < fields.length(); ++j) {
                    fieldNames.add(fields.getJSONObject(j).getString("fieldName"));
                }
                JSONObject properties = w.optJSONObject("properties");
                if (properties != null && properties.has("any")) {
                    properties = properties.getJSONObject("any");
                }
                WidgetDefinition wDef = new WidgetDefinition(w.getString("name"), w.getString("type"), labels.getString("any"), fieldNames, properties);
                widgetDefs.put(w.getString("name"), wDef);
                JSONArray options = w.optJSONArray(OPTIONS_DEF);
                if (options == null) continue;
                wDef.setSelectOptions(new SelectOptions(options));
                continue;
            }
            catch (JSONException e) {
                Log.e((String)LayoutJSONParser.class.getSimpleName(), (String)("Error while parling widget " + i), (Throwable)e);
                throw e;
            }
        }
        for (i = 0; i < rows.length(); ++i) {
            JSONObject rowObject = rows.getJSONObject(i);
            JSONArray w = rowObject.getJSONArray(WIDGETS_DEF);
            ArrayList<String> widgetNames = new ArrayList<String>();
            for (int j = 0; j < w.length(); ++j) {
                widgetNames.add(w.getJSONObject(j).getString("name"));
            }
            rowDefs.add(new LayoutRow(widgetNames));
        }
        return new LayoutDefinition(widgetDefs, rowDefs);
    }
}

