/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.NuxeoWidget;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class LayoutRow {
    List<String> widgetNames = new ArrayList<String>();

    public LayoutRow(List<String> widgetNames) {
        this.widgetNames = widgetNames;
    }

    public List<NuxeoWidget> buildRow(LayoutContext context, Document doc, ViewGroup container, Map<String, WidgetDefinition> widgetDefs, LayoutMode mode) {
        ViewGroup rowLayout = this.createTopLayoutContainer((Context)context.getActivity(), container, mode);
        ArrayList<NuxeoWidget> widgets = new ArrayList<NuxeoWidget>();
        for (String name : this.widgetNames) {
            NuxeoWidget widget;
            WidgetDefinition def = widgetDefs.get(name);
            if (def == null || (widget = def.build(context, doc, rowLayout, mode)) == null) continue;
            widgets.add(widget);
        }
        return widgets;
    }

    protected ViewGroup createTopLayoutContainer(Context ctx, ViewGroup parent, LayoutMode mode) {
        LinearLayout container = new LinearLayout(ctx);
        if (mode == LayoutMode.VIEW) {
            container.setOrientation(0);
        } else {
            container.setOrientation(1);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        container.setLayoutParams((ViewGroup.LayoutParams)params);
        parent.addView((View)container);
        return container;
    }
}

