/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.content.Intent;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.android.layout.ActivityResultHandler;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.NuxeoWidget;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class NuxeoLayout
implements ActivityResultHandler {
    protected List<NuxeoWidget> widgets = new ArrayList<NuxeoWidget>();
    protected Document doc;
    protected final LayoutContext context;

    public NuxeoLayout(LayoutContext context, Document doc) {
        this.context = context;
        this.doc = doc;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        for (NuxeoWidget widget : this.widgets) {
            ActivityResultHandler handler;
            Map<Integer, ActivityResultHandler> handlers = widget.getAndFlushPendingActivityResultHandler();
            if (handlers == null || (handler = handlers.get(requestCode)) == null) continue;
            handler.onActivityResult(requestCode, resultCode, data);
            return true;
        }
        return false;
    }

    public ViewGroup getContainer() {
        return this.context.getRootView();
    }

    void addWidgets(List<NuxeoWidget> newwidgets) {
        this.widgets.addAll(newwidgets);
    }

    public void applyChanges(Document doc) {
        this.doc = doc;
        for (NuxeoWidget widget : this.widgets) {
            widget.applyChanges(doc);
        }
    }

    public void refreshFromDocument(Document doc) {
        this.doc = doc;
        for (NuxeoWidget widget : this.widgets) {
            widget.refresh(doc);
        }
    }
}

